/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.s4hana.connectivity.Request;
import com.sap.cloud.sdk.s4hana.connectivity.RequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.RequestSerializer;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequest;
import com.sap.cloud.sdk.s4hana.connectivity.SerializedRequestResult;
import com.sap.cloud.sdk.s4hana.connectivity.exception.RequestSerializationException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequestSerializer<RequestT extends Request<RequestT, RequestResultT>, RequestResultT extends RequestResult<RequestT, RequestResultT>>
implements RequestSerializer<RequestT, RequestResultT> {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequestSerializer.class);

    @Override
    @Nonnull
    public final SerializedRequest<RequestT> serialize(@Nonnull RequestT request) throws RequestSerializationException {
        try {
            SerializedRequest<RequestT> result = this.serializeRequest(request);
            result.getRequestHeaders().addAll(((Request)request).getCustomHttpHeaders());
            return result;
        }
        catch (Exception e) {
            throw new RequestSerializationException(e);
        }
    }

    @Override
    @Nonnull
    public final RequestResultT deserialize(@Nonnull SerializedRequestResult<RequestT> requestResult) throws RequestSerializationException {
        try {
            return this.deserializeRequestResult(requestResult);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to deserialize request result from {}: {}", (Object)requestResult.getRequest().getClass().getSimpleName(), (Object)e.getMessage());
            }
            if (log.isTraceEnabled()) {
                log.trace("Unable to deserialize result body: {}", (Object)requestResult.getBody());
            }
            throw new RequestSerializationException(e);
        }
    }

    @Nonnull
    protected abstract SerializedRequest<RequestT> serializeRequest(@Nonnull RequestT var1) throws Exception;

    @Nonnull
    protected abstract RequestResultT deserializeRequestResult(@Nonnull SerializedRequestResult<RequestT> var1) throws Exception;
}

