/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import com.sap.cloud.sdk.cloudplatform.connectivity.AuthenticationType;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationPropertyKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyType;
import com.sap.cloud.sdk.cloudplatform.security.BasicCredentials;
import com.sap.cloud.sdk.s4hana.connectivity.ErpHttpDestination;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import io.vavr.control.Option;
import java.net.URI;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class DefaultErpHttpDestination
implements ErpHttpDestination {
    public static final String SAP_CLIENT_HEADER_NAME = "sap-client";
    public static final String LOCALE_HEADER_NAME = "sap-language";
    private static final DestinationPropertyKey<ProxyType> PROXY_TYPE_KEY = new DestinationPropertyKey<ProxyType>(){
        private final String keyName = "proxyType";
        private final Function<Object, ProxyType> fromMapConversion = ProxyType.class::cast;

        public String getKeyName() {
            return this.keyName;
        }

        public Function<Object, ProxyType> getFromMapConversion() {
            return this.fromMapConversion;
        }
    };
    private final HttpDestinationProperties baseDestination;

    public DefaultErpHttpDestination(@Nonnull HttpDestinationProperties baseDestination) {
        this.baseDestination = baseDestination;
    }

    @Nonnull
    public Option<Object> get(@Nonnull String key) {
        return this.baseDestination.get(key);
    }

    @Nonnull
    public URI getUri() {
        return this.baseDestination.getUri();
    }

    @Nonnull
    public Option<String> getTlsVersion() {
        return this.baseDestination.getTlsVersion();
    }

    @Nonnull
    public Option<ProxyConfiguration> getProxyConfiguration() {
        return this.baseDestination.getProxyConfiguration();
    }

    @Nonnull
    public Option<KeyStore> getKeyStore() {
        return this.baseDestination.getKeyStore();
    }

    @Nonnull
    public Option<String> getKeyStorePassword() {
        return this.baseDestination.getKeyStorePassword();
    }

    public boolean isTrustingAllCertificates() {
        return this.baseDestination.isTrustingAllCertificates();
    }

    @Nonnull
    public Option<BasicCredentials> getBasicCredentials() {
        return this.baseDestination.getBasicCredentials();
    }

    @Nonnull
    public Option<ProxyType> getProxyType() {
        return this.baseDestination.getProxyType();
    }

    @Nonnull
    public Option<String> getName() {
        return this.baseDestination.get("Name", String.class::cast);
    }

    @Nonnull
    public Option<KeyStore> getTrustStore() {
        return this.baseDestination.getTrustStore();
    }

    @Nonnull
    public Option<String> getTrustStorePassword() {
        return this.baseDestination.getTrustStorePassword();
    }

    @Nonnull
    public AuthenticationType getAuthenticationType() {
        return this.baseDestination.getAuthenticationType();
    }

    @Nonnull
    public Collection<Header> getHeaders(@Nonnull URI requestUri) {
        io.vavr.collection.List providedHeaders = io.vavr.collection.List.ofAll((Iterable)this.baseDestination.getHeaders(requestUri));
        List<Header> headersToAdd = this.getHeadersToAdd();
        io.vavr.collection.List allHeaders = providedHeaders.appendAll(headersToAdd);
        return allHeaders.distinctBy(Header::getName).toJavaList();
    }

    private List<Header> getHeadersToAdd() {
        ArrayList<Header> result = new ArrayList<Header>();
        result.add(new Header(LOCALE_HEADER_NAME, this.getLocale().getLanguage()));
        this.getSapClient().peek(sapClient -> result.add(new Header(SAP_CLIENT_HEADER_NAME, sapClient.getValue())));
        return result;
    }

    @Nonnull
    public static Builder builder(@Nonnull URI uri) {
        return new Builder(uri);
    }

    @Nonnull
    public static Builder builder(@Nonnull String uri) {
        return DefaultErpHttpDestination.builder(URI.create(uri));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultErpHttpDestination)) {
            return false;
        }
        DefaultErpHttpDestination other = (DefaultErpHttpDestination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpDestinationProperties this$baseDestination = this.baseDestination;
        HttpDestinationProperties other$baseDestination = other.baseDestination;
        return !(this$baseDestination == null ? other$baseDestination != null : !this$baseDestination.equals(other$baseDestination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DefaultErpHttpDestination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpDestinationProperties $baseDestination = this.baseDestination;
        result = result * 59 + ($baseDestination == null ? 43 : $baseDestination.hashCode());
        return result;
    }

    public static class Builder {
        private final DefaultHttpDestination.Builder builder;

        Builder(@Nonnull URI uri) {
            this.builder = DefaultHttpDestination.builder((URI)uri);
        }

        @Nonnull
        public Builder sapClient(@Nonnull SapClient sapClient) {
            this.builder.property(DefaultErpHttpDestination.SAP_CLIENT_HEADER_NAME, (Object)sapClient.getValue());
            return this;
        }

        @Nonnull
        public Builder locale(@Nonnull Locale locale) {
            this.builder.property(DefaultErpHttpDestination.LOCALE_HEADER_NAME, (Object)locale.getLanguage());
            return this;
        }

        @Nonnull
        public Builder tlsVersion(@Nonnull String value) {
            this.builder.tlsVersion(value);
            return this;
        }

        @Nonnull
        public Builder property(@Nonnull String key, @Nonnull Object value) {
            this.builder.property(key, value);
            return this;
        }

        @Nonnull
        public Builder keyStorePassword(@Nonnull String value) {
            this.builder.keyStorePassword(value);
            return this;
        }

        @Nonnull
        public Builder trustAllCertificates() {
            this.builder.trustAllCertificates();
            return this;
        }

        @Nonnull
        public Builder name(@Nonnull String name) {
            this.builder.name(name);
            return this;
        }

        @Nonnull
        public Builder proxy(@Nonnull URI proxyUri) {
            this.builder.proxy(proxyUri);
            return this;
        }

        @Nonnull
        public Builder proxy(@Nonnull String proxyHost, int proxyPort) {
            this.builder.proxy(proxyHost, proxyPort);
            return this;
        }

        @Nonnull
        public Builder uri(@Nonnull URI uri) {
            this.builder.uri(uri);
            return this;
        }

        @Nonnull
        public Builder network(@Nonnull ProxyType proxyType) {
            return this.property(PROXY_TYPE_KEY.getKeyName(), proxyType);
        }

        @Nonnull
        public Builder authenticationType(@Nonnull AuthenticationType authenticationType) {
            this.builder.authenticationType(authenticationType);
            return this;
        }

        @Nonnull
        public Builder user(@Nonnull String user) {
            this.builder.user(user);
            return this;
        }

        @Nonnull
        public Builder password(@Nonnull String password) {
            this.builder.password(password);
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull Header header) {
            this.builder.header(header);
            return this;
        }

        @Nonnull
        public Builder header(@Nonnull String headerName, @Nonnull String headerValue) {
            this.builder.header(headerName, headerValue);
            return this;
        }

        @Nonnull
        public DefaultErpHttpDestination build() {
            return new DefaultErpHttpDestination((HttpDestinationProperties)this.builder.build());
        }
    }
}

