/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity;

import java.time.Duration;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class RequestExecutionMeasurements {
    @Nullable
    private Long beginTotal;
    @Nullable
    private Long endTotal;
    @Nullable
    private Duration buildRequestDuration;
    @Nullable
    private Duration executeRequestDuration;
    @Nullable
    private Duration parseResponseDuration;

    @Nonnull
    public static String formatDuration(@Nullable Duration duration) {
        return duration == null ? "N/A" : duration.toString().substring(2).toLowerCase(Locale.ENGLISH);
    }

    public void addBuildRequestDuration(@Nonnull Duration duration) {
        this.buildRequestDuration = this.buildRequestDuration == null ? duration : this.buildRequestDuration.plus(duration);
    }

    public void addExecuteRequestDuration(@Nonnull Duration duration) {
        this.executeRequestDuration = this.executeRequestDuration == null ? duration : this.executeRequestDuration.plus(duration);
    }

    public void addParseResponseDuration(@Nonnull Duration duration) {
        this.parseResponseDuration = this.parseResponseDuration == null ? duration : this.parseResponseDuration.plus(duration);
    }

    public void resetMeasurements() {
        this.beginTotal = null;
        this.endTotal = null;
        this.buildRequestDuration = null;
        this.executeRequestDuration = null;
        this.parseResponseDuration = null;
    }

    @Nonnull
    public String getMeasurementsString() {
        Duration total = this.beginTotal != null && this.endTotal != null ? Duration.ofNanos(this.endTotal - this.beginTotal) : null;
        return "total: " + RequestExecutionMeasurements.formatDuration(total) + ", build payload: " + RequestExecutionMeasurements.formatDuration(this.buildRequestDuration) + ", execute request: " + RequestExecutionMeasurements.formatDuration(this.executeRequestDuration) + ", parse response: " + RequestExecutionMeasurements.formatDuration(this.parseResponseDuration);
    }

    @Nullable
    @Generated
    public Long getBeginTotal() {
        return this.beginTotal;
    }

    @Nullable
    @Generated
    public Long getEndTotal() {
        return this.endTotal;
    }

    @Nullable
    @Generated
    public Duration getBuildRequestDuration() {
        return this.buildRequestDuration;
    }

    @Nullable
    @Generated
    public Duration getExecuteRequestDuration() {
        return this.executeRequestDuration;
    }

    @Nullable
    @Generated
    public Duration getParseResponseDuration() {
        return this.parseResponseDuration;
    }

    @Generated
    public void setBeginTotal(@Nullable Long beginTotal) {
        this.beginTotal = beginTotal;
    }

    @Generated
    public void setEndTotal(@Nullable Long endTotal) {
        this.endTotal = endTotal;
    }
}

