/*
 * Decompiled with CFR 0.152.
 */
package com.simboss.sdk;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.simboss.sdk.conf.SimbossConfig;
import com.simboss.sdk.exception.SimbossException;
import com.simboss.sdk.request.SimbossRequest;
import com.simboss.sdk.response.SimbossResponse;
import com.simboss.sdk.utils.SignatureUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimbossClient {
    private Logger logger = LoggerFactory.getLogger(SimbossClient.class);
    private CloseableHttpAsyncClient closeableHttpAsyncClient;
    private static final String defaultCharSet = "UTF-8";
    private SimbossConfig config;

    public SimbossClient() {
        this.config = new SimbossConfig().build();
    }

    public SimbossClient(String appId, String appSecret) {
        this.config = new SimbossConfig(null, appId, appSecret).build();
    }

    public SimbossClient(String appId, String appSecret, InputStream confIn) {
        this.config = new SimbossConfig(null, appId, appSecret).withConf(confIn).build();
    }

    public SimbossClient(String apiUrl, String appId, String appSecret) {
        this.config = new SimbossConfig(apiUrl, appId, appSecret).build();
    }

    public SimbossClient(String apiUrl, String appId, String appSecret, InputStream confIn) {
        this.config = new SimbossConfig(apiUrl, appId, appSecret).withConf(confIn).build();
    }

    public SimbossClient(InputStream confIn) {
        this.config = new SimbossConfig().withConf(confIn).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SimbossResponse> T excute(SimbossRequest request) {
        SimbossResponse response = null;
        HttpResponse httpResponse = null;
        HttpEntity resultEntity = null;
        try {
            String url = this.config.getApiUrl() + request.getUri();
            HttpPost post = new HttpPost(url);
            TreeMap<String, String> paramTreeMap = this.getRequestParam(request);
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            Set<String> keys = paramTreeMap.keySet();
            for (String key : keys) {
                formparams.add(new BasicNameValuePair(key, paramTreeMap.get(key)));
            }
            UrlEncodedFormEntity paramEntity = new UrlEncodedFormEntity(formparams, defaultCharSet);
            post.setEntity((HttpEntity)paramEntity);
            Future future = this.closeableHttpAsyncClient.execute((HttpUriRequest)post, null);
            httpResponse = (HttpResponse)future.get();
            resultEntity = httpResponse.getEntity();
            String result = EntityUtils.toString((HttpEntity)resultEntity, (String)defaultCharSet);
            this.logger.debug("request url: " + url + ", statusCode:" + httpResponse.getStatusLine().getStatusCode() + ", param:" + EntityUtils.toString((HttpEntity)paramEntity, (String)defaultCharSet) + ", result: " + result);
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
            response = (SimbossResponse)gson.fromJson(result, request.getResponseType());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            response.setSuccess(false);
            response.setMessage(e.getMessage());
            response.setCode("599");
        }
        finally {
            if (resultEntity != null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponse.getEntity());
            }
        }
        return (T)response;
    }

    private TreeMap<String, String> getRequestParam(SimbossRequest request) {
        TreeMap<String, String> paramTreeMap = request.getParam();
        paramTreeMap.put("appid", this.config.getAppId());
        paramTreeMap.put("timestamp", System.currentTimeMillis() + "");
        String sign = SignatureUtil.getSignature(paramTreeMap, this.config.getAppSecret());
        paramTreeMap.put("sign", sign);
        return paramTreeMap;
    }

    public SimbossClient init() {
        try {
            this.logger.info("start simboss client...");
            if (this.closeableHttpAsyncClient != null) {
                this.close();
            }
            IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(this.config.getConnectionTimeout().intValue()).setSoTimeout(this.config.getSocketTimeout().intValue()).build();
            DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
            PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Charset.forName(defaultCharSet)).build();
            connManager.setDefaultConnectionConfig(connectionConfig);
            connManager.setMaxTotal(this.config.getPoolMaxTotal().intValue());
            connManager.setDefaultMaxPerRoute(this.config.getPoolDefaultMaxPerRoute().intValue());
            this.closeableHttpAsyncClient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connManager).build();
            this.closeableHttpAsyncClient.start();
            return this;
        }
        catch (IOReactorException e) {
            this.close();
            String msg = "start simboss client error, errMsg:" + e.getMessage();
            this.logger.error(msg, (Throwable)e);
            throw new SimbossException(msg, e);
        }
    }

    public void close() {
        this.logger.info("close simboss client");
        if (this.closeableHttpAsyncClient != null) {
            try {
                this.closeableHttpAsyncClient.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

