/*
 * Decompiled with CFR 0.152.
 */
package com.simboss.sdk.request;

import com.google.gson.reflect.TypeToken;
import com.simboss.sdk.constant.UriConstants;
import com.simboss.sdk.dto.DailyUsageDTO;
import com.simboss.sdk.dto.ThreeIdCombineDTO;
import com.simboss.sdk.exception.SimbossException;
import com.simboss.sdk.request.SimbossRequest;
import com.simboss.sdk.response.SimbossResponse;
import com.simboss.sdk.utils.DateTimeUtil;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.TreeMap;

public class DeviceDailyUsageRequest
extends ThreeIdCombineDTO
implements SimbossRequest {
    private Date date;

    @Override
    public String getUri() {
        return UriConstants.URI_DEVICE_DAILY_USAGE;
    }

    @Override
    public TreeMap<String, String> getParam() {
        TreeMap<String, String> map = super.getParam();
        if (this.date == null) {
            throw new SimbossException("param date is required");
        }
        map.put("date", DateTimeUtil.convertDateToString(this.date, "yyyy-MM-dd"));
        return map;
    }

    @Override
    public Type getResponseType() {
        return new TypeToken<SimbossResponse<DailyUsageDTO>>(){}.getType();
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

