/*
 * Decompiled with CFR 0.152.
 */
package com.stoyanr.evictor.map;

import com.stoyanr.evictor.map.ConcurrentMapWithTimedEvictionDecorator;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class EvictibleEntry<K, V>
implements Map.Entry<K, V> {
    private final ConcurrentMapWithTimedEvictionDecorator<K, V> map;
    private final K key;
    private volatile V value;
    private final long evictMs;
    private final boolean evictible;
    private final long evictionTime;
    private volatile Object data;

    EvictibleEntry(ConcurrentMapWithTimedEvictionDecorator<K, V> map, K key, V value, long evictMs) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
        if (evictMs < 0L) {
            throw new IllegalArgumentException("Eviction time cannot be less than zero");
        }
        this.map = map;
        this.key = key;
        this.value = value;
        this.evictMs = evictMs;
        this.evictible = evictMs > 0L;
        this.evictionTime = this.evictible ? System.nanoTime() + TimeUnit.NANOSECONDS.convert(evictMs, TimeUnit.MILLISECONDS) : 0L;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public synchronized V setValue(V value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        V oldValue = this.value;
        this.value = value;
        return oldValue;
    }

    public boolean isEvictible() {
        return this.evictible;
    }

    public long getEvictionTime() {
        return this.evictionTime;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean shouldEvict() {
        return this.evictible ? System.nanoTime() > this.evictionTime : false;
    }

    public void evict(boolean cancelPendingEviction) {
        this.map.evict(this, cancelPendingEviction);
    }

    public String toString() {
        return String.format("[%s, %s, %d]", this.key != null ? this.key : "null", this.value, this.evictMs);
    }
}

