/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBDatabaseMetaData;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBJNIConnector;
import com.taosdata.jdbc.TSDBPreparedStatement;
import com.taosdata.jdbc.TSDBStatement;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class TSDBConnection
extends AbstractConnection {
    private TSDBJNIConnector connector;
    private final TSDBDatabaseMetaData databaseMetaData;
    private boolean batchFetch;
    private CopyOnWriteArrayList<Statement> statements = new CopyOnWriteArrayList();

    public Boolean getBatchFetch() {
        return this.batchFetch;
    }

    public TSDBConnection(Properties info, TSDBDatabaseMetaData meta) throws SQLException {
        super(info);
        this.databaseMetaData = meta;
        this.connect(info.getProperty("host"), Integer.parseInt(info.getProperty("port", "0")), info.getProperty("dbname"), info.getProperty("user"), info.getProperty("password"));
        String batchLoad = info.getProperty("batchfetch", "true");
        if (batchLoad != null) {
            this.batchFetch = Boolean.parseBoolean(batchLoad);
        }
    }

    private void connect(String host, int port, String dbName, String user, String password) throws SQLException {
        this.connector = new TSDBJNIConnector();
        this.connector.connect(host, port, dbName, user, password);
        this.catalog = dbName;
        this.databaseMetaData.setConnection(this);
    }

    public TSDBJNIConnector getConnector() {
        return this.connector;
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new TSDBStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return new TSDBPreparedStatement(this, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        TSDBConnection tSDBConnection = this;
        synchronized (tSDBConnection) {
            if (this.isClosed) {
                return;
            }
            for (Statement statement : this.statements) {
                statement.close();
            }
            this.connector.closeConnection();
            this.isClosed = true;
        }
    }

    public void unregisterStatement(Statement stmt) {
        this.statements.remove(stmt);
    }

    public void registerStatement(Statement stmt) {
        this.statements.addIfAbsent(stmt);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.connector != null && this.connector.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.databaseMetaData;
    }

    @Override
    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        if (null == ttl && null == reqId) {
            this.connector.insertLines(lines, protocolType, timestampType);
        } else if (null == reqId) {
            this.connector.insertLinesWithTtl(lines, protocolType, timestampType, ttl);
        } else if (null == ttl) {
            this.connector.insertLinesWithReqId(lines, protocolType, timestampType, reqId);
        } else {
            this.connector.insertLinesWithTtlAndReqId(lines, protocolType, timestampType, ttl, reqId);
        }
    }

    @Override
    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        if (null == ttl && null == reqId) {
            return this.connector.insertRaw(line, protocolType, timestampType);
        }
        if (null == reqId) {
            return this.connector.insertRawWithTtl(line, protocolType, timestampType, ttl);
        }
        if (null == ttl) {
            return this.connector.insertRawWithReqId(line, protocolType, timestampType, reqId);
        }
        return this.connector.insertRawWithTtlAndReqId(line, protocolType, timestampType, ttl, reqId);
    }
}

