/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.AbstractStatement;
import com.taosdata.jdbc.TSDBConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.TSDBResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TSDBStatement
extends AbstractStatement {
    private boolean isClosed;
    private TSDBConnection connection;
    private TSDBResultSet resultSet;
    private int queryTimeout;

    TSDBStatement(TSDBConnection connection) {
        this.connection = connection;
        connection.registerStatement(this);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    @Override
    public ResultSet executeQuery(String sql, Long reqId) throws SQLException {
        if (this.queryTimeout > 0) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
            Future<ResultSet> f = executor.submit(() -> this.executeQueryImpl(sql, reqId));
            try {
                ResultSet resultSet = f.get(this.queryTimeout, TimeUnit.SECONDS);
                return resultSet;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SQLException("failed to execute sql: " + sql + ", cause: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                f.cancel(true);
                throw new SQLTimeoutException("failed to execute sql: " + sql + ", cause: the execution time exceeds timeout: " + this.queryTimeout + " seconds");
            }
            finally {
                executor.shutdownNow();
            }
        }
        return this.executeQueryImpl(sql, reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQueryImpl(String sql, Long reqId) throws SQLException {
        TSDBStatement tSDBStatement = this;
        synchronized (tSDBStatement) {
            if (this.isClosed()) {
                throw TSDBError.createSQLException(8964);
            }
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            long pSql = this.connection.getConnector().executeQuery(sql, reqId);
            if (this.connection.getConnector().isUpdateQuery(pSql)) {
                this.connection.getConnector().freeResultSet(pSql);
                throw TSDBError.createSQLException(8967);
            }
            int timestampPrecision = this.connection.getConnector().getResultTimePrecision(pSql);
            this.resultSet = new TSDBResultSet(this, this.connection.getConnector(), pSql, timestampPrecision, this.connection.getBatchFetch());
            return this.resultSet;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, (Long)null);
    }

    @Override
    public int executeUpdate(String sql, Long reqId) throws SQLException {
        if (this.queryTimeout > 0) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
            Future<Integer> f = executor.submit(() -> this.executeUpdateImpl(sql, reqId));
            try {
                int n = f.get(this.queryTimeout, TimeUnit.SECONDS);
                return n;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SQLException("failed to execute sql: " + sql + ", cause: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                f.cancel(true);
                throw new SQLTimeoutException("failed to execute sql: " + sql + ", cause: the execution time exceeds timeout: " + this.queryTimeout + " seconds");
            }
            finally {
                executor.shutdownNow();
            }
        }
        return this.executeUpdateImpl(sql, reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateImpl(String sql, Long reqId) throws SQLException {
        TSDBStatement tSDBStatement = this;
        synchronized (tSDBStatement) {
            if (this.isClosed()) {
                throw TSDBError.createSQLException(8964);
            }
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            long pSql = this.connection.getConnector().executeQuery(sql, reqId);
            if (!this.connection.getConnector().isUpdateQuery(pSql)) {
                this.connection.getConnector().freeResultSet(pSql);
                throw TSDBError.createSQLException(8968);
            }
            int affectedRows = this.connection.getConnector().getAffectedRows(pSql);
            this.connection.getConnector().freeResultSet(pSql);
            return affectedRows;
        }
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        super.setQueryTimeout(queryTimeout);
        this.queryTimeout = queryTimeout;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        super.getQueryTimeout();
        return this.queryTimeout;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.connection.unregisterStatement(this);
        if (this.resultSet != null && !this.resultSet.isClosed()) {
            this.resultSet.close();
        }
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, (Long)null);
    }

    @Override
    public boolean execute(String sql, Long reqId) throws SQLException {
        if (this.queryTimeout > 0) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());
            Future<Boolean> f = executor.submit(() -> this.executeImpl(sql, reqId));
            try {
                boolean bl = f.get(this.queryTimeout, TimeUnit.SECONDS);
                return bl;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SQLException("failed to execute sql: " + sql + ", cause: " + e.getMessage(), e);
            }
            catch (TimeoutException e) {
                f.cancel(true);
                throw new SQLTimeoutException("failed to execute sql: " + sql + ", cause: the execution time exceeds timeout: " + this.queryTimeout + " seconds");
            }
            finally {
                executor.shutdownNow();
            }
        }
        return this.executeImpl(sql, reqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeImpl(String sql, Long reqId) throws SQLException {
        TSDBStatement tSDBStatement = this;
        synchronized (tSDBStatement) {
            if (this.isClosed()) {
                throw TSDBError.createSQLException(8964);
            }
            if (this.resultSet != null && !this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            long pSql = this.connection.getConnector().executeQuery(sql, reqId);
            if (this.connection.getConnector().isUpdateQuery(pSql)) {
                this.affectedRows = this.connection.getConnector().getAffectedRows(pSql);
                this.connection.getConnector().freeResultSet(pSql);
                return false;
            }
            int timestampPrecision = this.connection.getConnector().getResultTimePrecision(pSql);
            this.resultSet = new TSDBResultSet(this, this.connection.getConnector(), pSql, timestampPrecision, this.connection.getBatchFetch());
            return true;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        return this.affectedRows;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8964);
        }
        if (this.connection.getConnector() == null) {
            throw TSDBError.createSQLException(9044);
        }
        return this.connection;
    }

    public void setConnection(TSDBConnection connection) {
        this.connection = connection;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }
}

