/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.taosdata.jdbc.AbstractConnection;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.SchemalessProtocolType;
import com.taosdata.jdbc.enums.SchemalessTimestampType;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.rs.RestfulDatabaseMetaData;
import com.taosdata.jdbc.utils.ReqId;
import com.taosdata.jdbc.ws.TSWSPreparedStatement;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WSStatement;
import com.taosdata.jdbc.ws.entity.Action;
import com.taosdata.jdbc.ws.entity.Code;
import com.taosdata.jdbc.ws.entity.ConnectReq;
import com.taosdata.jdbc.ws.entity.ConnectResp;
import com.taosdata.jdbc.ws.entity.Request;
import com.taosdata.jdbc.ws.schemaless.CommonResp;
import com.taosdata.jdbc.ws.schemaless.InsertReq;
import com.taosdata.jdbc.ws.schemaless.SchemalessAction;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class WSConnection
extends AbstractConnection {
    public static boolean g_FirstConnection = true;
    private final Transport transport;
    private final DatabaseMetaData metaData;
    private String database;
    private final ConnectionParam param;
    CopyOnWriteArrayList<Statement> statementList = new CopyOnWriteArrayList();
    private final AtomicLong insertId = new AtomicLong(0L);

    public WSConnection(String url, Properties properties, Transport transport, ConnectionParam param) {
        super(properties);
        this.transport = transport;
        this.database = param.getDatabase();
        this.param = param;
        this.metaData = new RestfulDatabaseMetaData(url, properties.getProperty("user"), this);
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        WSStatement statement = new WSStatement(this.transport, this.database, this);
        this.statementList.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.getClientInfo("dbname") != null) {
            this.database = this.getClientInfo("dbname");
        }
        if (this.transport != null && !this.transport.isClosed()) {
            return new TSWSPreparedStatement(this.transport, this.param, this.database, this, sql);
        }
        throw TSDBError.createSQLException(8961);
    }

    @Override
    public void close() throws SQLException {
        for (Statement statement : this.statementList) {
            statement.close();
        }
        this.transport.close();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.transport.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return this.metaData;
    }

    public static void reInitTransport(Transport transport, ConnectionParam param, String db) throws SQLException {
        transport.disconnectAndReconnect();
        ConnectReq connectReq = new ConnectReq();
        connectReq.setReqId(ReqId.getReqID());
        connectReq.setUser(param.getUser());
        connectReq.setPassword(param.getPassword());
        connectReq.setDb(db);
        if (param.getConnectMode() == 1) {
            connectReq.setMode(0);
        }
        ConnectResp auth = (ConnectResp)transport.send(new Request(Action.CONN.getAction(), connectReq));
        if (Code.SUCCESS.getCode() != auth.getCode()) {
            transport.close();
            throw new SQLException("(0x" + Integer.toHexString(auth.getCode()) + "):auth failure:" + auth.getMessage());
        }
    }

    public ConnectionParam getParam() {
        return this.param;
    }

    @Override
    public void write(String[] lines, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        for (String line : lines) {
            InsertReq insertReq = new InsertReq();
            insertReq.setReqId(this.insertId.getAndIncrement());
            insertReq.setProtocol(protocolType.ordinal());
            insertReq.setPrecision(timestampType.getType());
            insertReq.setData(line);
            if (ttl != null) {
                insertReq.setTtl(ttl);
            }
            if (reqId != null) {
                insertReq.setReqId(reqId);
            }
            CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
            if (Code.SUCCESS.getCode() == response.getCode()) continue;
            throw new SQLException("0x" + Integer.toHexString(response.getCode()) + ":" + response.getMessage());
        }
    }

    @Override
    public int writeRaw(String line, SchemalessProtocolType protocolType, SchemalessTimestampType timestampType, Integer ttl, Long reqId) throws SQLException {
        InsertReq insertReq = new InsertReq();
        insertReq.setReqId(this.insertId.getAndIncrement());
        insertReq.setProtocol(protocolType.ordinal());
        insertReq.setPrecision(timestampType.getType());
        insertReq.setData(line);
        if (ttl != null) {
            insertReq.setTtl(ttl);
        }
        if (reqId != null) {
            insertReq.setReqId(reqId);
        }
        CommonResp response = (CommonResp)this.transport.send(new Request(SchemalessAction.INSERT.getAction(), insertReq));
        if (Code.SUCCESS.getCode() != response.getCode()) {
            throw new SQLException("(0x" + Integer.toHexString(response.getCode()) + "):" + response.getMessage());
        }
        return 0;
    }
}

