/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.AbstractDatabaseMetaData;
import com.taosdata.jdbc.EmptyResultSet;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.rs.RestfulDriver;
import com.taosdata.jdbc.ws.WSConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RestfulDatabaseMetaData
extends AbstractDatabaseMetaData {
    private final String url;
    private final String userName;
    private final Connection connection;

    public RestfulDatabaseMetaData(String url, String userName, Connection connection) {
        this.url = url;
        this.userName = userName;
        this.connection = connection;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    @Override
    public String getDriverName() throws SQLException {
        return RestfulDriver.class.getName();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        if (this.connection instanceof WSConnection) {
            WSConnection wsConnection = (WSConnection)this.connection;
            int n = wsConnection.getParam().getConnectMode();
            wsConnection.getParam();
            if (n == 1 && types.length == 1 && types[0].equals("VIEW")) {
                return new EmptyResultSet();
            }
        }
        return super.getTables(catalog, schemaPattern, tableNamePattern, types, this.connection);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getCatalogs(this.connection);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getTableTypes();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern, this.connection);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getPrimaryKeys(catalog, schema, table, this.connection);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        if (this.connection == null || this.connection.isClosed()) {
            throw TSDBError.createSQLException(8961);
        }
        return super.getSuperTables(catalog, schemaPattern, tableNamePattern, this.connection);
    }
}

