/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc;

import com.taosdata.jdbc.TaosGlobalConfig;
import com.taosdata.jdbc.utils.DataTypeConverUtil;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;

public class TSDBResultSetRowData {
    private ArrayList<Object> data;
    private final int colSize;

    public TSDBResultSetRowData(int colSize) {
        this.colSize = colSize;
        this.clear();
    }

    public void clear() {
        if (this.data != null) {
            this.data.clear();
        }
        if (this.colSize == 0) {
            return;
        }
        this.data = new ArrayList(this.colSize);
        this.data.addAll(Collections.nCopies(this.colSize, null));
    }

    public boolean wasNull(int col) {
        return this.data.get(col - 1) == null;
    }

    public void setBooleanValue(int col, boolean value) {
        this.setBoolean(col - 1, value);
    }

    public void setBoolean(int col, boolean value) {
        this.data.set(col, value);
    }

    public boolean getBoolean(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return DataTypeConverUtil.getBoolean(nativeType, obj);
    }

    public void setByteValue(int colIndex, byte value) {
        this.setByte(colIndex - 1, value);
    }

    public void setByte(int col, byte value) {
        this.data.set(col, value);
    }

    public void setShortValue(int colIndex, short value) {
        this.setShort(colIndex - 1, value);
    }

    public void setShort(int col, short value) {
        this.data.set(col, value);
    }

    public void setIntValue(int colIndex, int value) {
        this.setInt(colIndex - 1, value);
    }

    public void setInt(int col, int value) {
        this.data.set(col, value);
    }

    public int getInt(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0;
        }
        return DataTypeConverUtil.getInt(nativeType, obj, col);
    }

    public void setLongValue(int colIndex, long value) {
        this.setLong(colIndex - 1, value);
    }

    public void setLong(int col, long value) {
        this.data.set(col, value);
    }

    public long getLong(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        return DataTypeConverUtil.getLong(nativeType, obj, col, 0);
    }

    public void setFloatValue(int colIndex, float value) {
        this.setFloat(colIndex - 1, value);
    }

    public void setFloat(int col, float value) {
        this.data.set(col, Float.valueOf(value));
    }

    public float getFloat(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        return DataTypeConverUtil.getFloat(nativeType, obj, col);
    }

    public void setDoubleValue(int colIndex, double value) {
        this.setDouble(colIndex - 1, value);
    }

    public void setDouble(int col, double value) {
        this.data.set(col, value);
    }

    public double getDouble(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return 0.0;
        }
        return DataTypeConverUtil.getDouble(nativeType, obj, col, 0);
    }

    public void setStringValue(int colIndex, String value) {
        this.data.set(colIndex - 1, value);
    }

    public void setString(int col, String value) {
        this.data.set(col, value == null ? null : value.getBytes());
    }

    public void setByteArrayValue(int colIndex, byte[] value) {
        this.setByteArray(colIndex - 1, value);
    }

    public void setByteArray(int col, byte[] value) {
        try {
            this.data.set(col, new String(value, TaosGlobalConfig.getCharset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getString(int col, int nativeType) throws SQLException {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        return DataTypeConverUtil.getString(obj);
    }

    public void setTimestampValue(int colIndex, long value) {
        this.setTimestamp(colIndex - 1, value, 0);
    }

    public void setTimestamp(int col, long ts, int precision) {
        int fracNanoseconds;
        long milliseconds;
        switch (precision) {
            case 0: {
                milliseconds = ts;
                fracNanoseconds = (int)(ts * 1000000L % 1000000000L);
                fracNanoseconds = fracNanoseconds < 0 ? 1000000000 + fracNanoseconds : fracNanoseconds;
                break;
            }
            case 1: {
                milliseconds = ts / 1000L;
                fracNanoseconds = (int)(ts * 1000L % 1000000000L);
                if (fracNanoseconds >= 0) break;
                if (milliseconds == 0L) {
                    milliseconds = -1L;
                }
                fracNanoseconds += 1000000000;
                break;
            }
            case 2: {
                milliseconds = ts / 1000000L;
                fracNanoseconds = (int)(ts % 1000000000L);
                if (fracNanoseconds >= 0) break;
                if (milliseconds == 0L) {
                    milliseconds = -1L;
                }
                fracNanoseconds += 1000000000;
                break;
            }
            default: {
                throw new IllegalArgumentException("precision is not valid. precision: " + precision);
            }
        }
        Timestamp tsObj = new Timestamp(milliseconds);
        tsObj.setNanos(fracNanoseconds);
        this.data.set(col, tsObj);
    }

    public void setTimestamp(int col, long ts) {
        if (ts < 10000000000000L) {
            this.data.set(col, new Timestamp(ts));
        } else {
            long epochSec = ts / 1000000L;
            long nanoAdjustment = ts % 1000000L * 1000L;
            Timestamp timestamp = Timestamp.from(Instant.ofEpochSecond(epochSec, nanoAdjustment));
            this.data.set(col, timestamp);
        }
    }

    public Timestamp getTimestamp(int col, int nativeType) {
        Object obj = this.data.get(col - 1);
        if (obj == null) {
            return null;
        }
        if (nativeType == 5) {
            return new Timestamp((Long)obj);
        }
        return (Timestamp)obj;
    }

    public Object getObject(int col) {
        return this.data.get(col - 1);
    }
}

