/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.ws;

import com.google.common.base.Strings;
import com.taosdata.jdbc.TSDBError;
import com.taosdata.jdbc.enums.WSFunction;
import com.taosdata.jdbc.rs.ConnectionParam;
import com.taosdata.jdbc.utils.StringUtils;
import com.taosdata.jdbc.utils.Utils;
import com.taosdata.jdbc.ws.CustomWebSocketClientHandshaker;
import com.taosdata.jdbc.ws.Transport;
import com.taosdata.jdbc.ws.WebSocketClientHandler;
import com.taosdata.jdbc.ws.WebSocketHandshakeHandler;
import com.taosdata.jdbc.ws.WebsocketNotConnectedException;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameClientExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateClientExtensionHandshaker;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.TimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(WSClient.class);
    Transport transport;
    public final URI serverUri;
    private final String host;
    private final int port;
    private Channel channel;
    private final ConnectionParam connectionParam;

    public WSClient(URI serverUri, Transport transport, ConnectionParam connectionParam) {
        this.transport = transport;
        this.serverUri = serverUri;
        this.connectionParam = connectionParam;
        this.channel = null;
        String scheme = serverUri.getScheme() == null ? "ws" : serverUri.getScheme();
        String string = this.host = serverUri.getHost() == null ? "127.0.0.1" : serverUri.getHost();
        this.port = serverUri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : 443) : serverUri.getPort();
    }

    private Channel getChannel() throws SQLException {
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group(Utils.getEventLoopGroup())).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.connectionParam.getConnectTimeout())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws SSLException {
                ChannelPipeline p = ch.pipeline();
                if (WSClient.this.connectionParam.isUseSsl()) {
                    SslContext sslCtx;
                    if (WSClient.this.connectionParam.isDisableSslCertValidation()) {
                        sslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), WSClient.this.host, WSClient.this.port)});
                    } else {
                        sslCtx = SslContextBuilder.forClient().build();
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), WSClient.this.host, WSClient.this.port)});
                    }
                }
                p.addLast(new ChannelHandler[]{new HttpClientCodec()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
                CustomWebSocketClientHandshaker handshaker = new CustomWebSocketClientHandshaker(WSClient.this.serverUri, WebSocketVersion.V13, null, true, (HttpHeaders)new DefaultHttpHeaders(), 0x6400000, true, false, -1L);
                p.addLast(new ChannelHandler[]{new WebSocketHandshakeHandler((WebSocketClientHandshaker)handshaker)});
                if (WSClient.this.connectionParam.isEnableCompression()) {
                    PerMessageDeflateClientExtensionHandshaker deflateHandshaker = new PerMessageDeflateClientExtensionHandshaker(6, false, 15, true, true);
                    WebSocketClientExtensionHandler extensionHandler = new WebSocketClientExtensionHandler(new WebSocketClientExtensionHandshaker[]{deflateHandshaker, new DeflateFrameClientExtensionHandshaker(false), new DeflateFrameClientExtensionHandshaker(true)});
                    p.addLast(new ChannelHandler[]{extensionHandler});
                }
                p.addLast(new ChannelHandler[]{new WebSocketFrameAggregator(0x6400000)});
                WebSocketClientHandler handler = new WebSocketClientHandler(WSClient.this.connectionParam.getTextMessageHandler(), WSClient.this.connectionParam.getBinaryMessageHandler());
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        ChannelFuture connectFuture = b.connect(this.host, this.port);
        Channel tmpChn = null;
        try {
            if (!connectFuture.awaitUninterruptibly((long)this.connectionParam.getConnectTimeout())) {
                throw TSDBError.createSQLException(8989);
            }
            if (!connectFuture.isSuccess()) {
                Throwable cause = connectFuture.cause();
                if (cause instanceof ConnectTimeoutException) {
                    throw TSDBError.createSQLException(8989);
                }
                throw TSDBError.createSQLException(9040, cause.getMessage());
            }
            tmpChn = connectFuture.channel();
            WebSocketHandshakeHandler wsHandler = (WebSocketHandshakeHandler)tmpChn.pipeline().get(WebSocketHandshakeHandler.class);
            ChannelFuture handshakeFuture = wsHandler.handshakeFuture();
            if (!handshakeFuture.awaitUninterruptibly((long)this.connectionParam.getConnectTimeout())) {
                tmpChn.close().syncUninterruptibly();
                throw TSDBError.createSQLException(8989, "Handshake timed out");
            }
            if (!handshakeFuture.isSuccess()) {
                tmpChn.close().syncUninterruptibly();
                throw TSDBError.createSQLException(9040, "Handshake failed: " + handshakeFuture.cause().getMessage());
            }
            tmpChn.pipeline().remove((ChannelHandler)wsHandler);
            return tmpChn;
        }
        catch (TimeoutException e) {
            if (tmpChn != null) {
                tmpChn.close().syncUninterruptibly();
            }
            throw TSDBError.createSQLException(8989, e.getMessage());
        }
    }

    public boolean isOpen() {
        return this.channel.isActive();
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void close() {
        if (this.channel != null && this.channel.isOpen()) {
            int statusCode = 1000;
            String reason = "Normal close";
            CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(statusCode, reason);
            ChannelFuture writeFuture = this.channel.writeAndFlush((Object)closeFrame);
            this.channel.attr(WebSocketClientHandler.LOCAL_INITIATED_CLOSE).set((Object)true);
            writeFuture.syncUninterruptibly();
            ChannelFuture closeFuture = this.channel.close();
            closeFuture.syncUninterruptibly();
            if (closeFuture.isSuccess()) {
                log.debug("WebSocket connection closed successfully");
            } else {
                log.error("WebSocket connection closed error", closeFuture.cause());
            }
        }
    }

    public boolean reconnectBlockingWithoutRetry() {
        return this.connectBlocking();
    }

    public boolean connectBlocking() {
        if (this.channel != null && this.channel.isActive()) {
            return true;
        }
        if (this.channel != null) {
            this.channel.close().syncUninterruptibly();
        }
        try {
            this.channel = this.getChannel();
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean reconnectBlocking() {
        return this.connectBlocking();
    }

    public void send(String strData) {
        if (!this.channel.isActive()) {
            throw new WebsocketNotConnectedException();
        }
        this.channel.eventLoop().execute(() -> this.channel.writeAndFlush((Object)new TextWebSocketFrame(strData)));
    }

    public void send(ByteBuf binData) {
        if (!this.channel.isActive()) {
            Utils.releaseByteBuf(binData);
            throw new WebsocketNotConnectedException();
        }
        this.channel.writeAndFlush((Object)new BinaryWebSocketFrame(binData));
    }

    public void closeBlocking() {
        this.close();
    }

    public static WSClient getInstance(ConnectionParam params, WSFunction function, Transport transport) throws SQLException {
        URI urlPath;
        if (Strings.isNullOrEmpty((String)function.getFunction())) {
            throw new SQLException("websocket url error");
        }
        String protocol = "ws";
        if (params.isUseSsl()) {
            protocol = "wss";
        }
        String port = "";
        if (null != params.getPort()) {
            port = ":" + params.getPort();
        }
        String wsFunction = "/ws";
        if (function.equals((Object)WSFunction.TMQ)) {
            wsFunction = "/rest/tmq";
        }
        String loginUrl = protocol + "://" + params.getHost() + port + wsFunction;
        if (null != params.getCloudToken()) {
            loginUrl = loginUrl + "?token=" + params.getCloudToken();
        }
        try {
            urlPath = new URI(loginUrl);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Websocket url parse error: " + loginUrl, e);
        }
        return new WSClient(urlPath, transport, params);
    }

    public static WSClient getSlaveInstance(ConnectionParam params, WSFunction function, Transport transport) throws SQLException {
        URI urlPath;
        if (StringUtils.isEmpty(params.getSlaveClusterHost()) || StringUtils.isEmpty(params.getSlaveClusterHost())) {
            return null;
        }
        if (Strings.isNullOrEmpty((String)function.getFunction())) {
            throw new SQLException("websocket url error");
        }
        String protocol = "ws";
        if (params.isUseSsl()) {
            protocol = "wss";
        }
        String port = ":" + params.getSlaveClusterPort();
        String wsFunction = "/ws";
        if (!function.equals((Object)WSFunction.WS)) {
            throw new SQLException("slave cluster is not supported!");
        }
        String loginUrl = protocol + "://" + params.getSlaveClusterHost() + port + wsFunction;
        try {
            urlPath = new URI(loginUrl);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Slave cluster websocket url parse error: " + loginUrl, e);
        }
        return new WSClient(urlPath, transport, params);
    }

    static {
        Utils.initEventLoopGroup();
    }
}

