/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServletService;
import java.util.Enumeration;
import java.util.function.Supplier;
import javax.servlet.ServletContext;

public class VaadinServletContext
implements VaadinContext {
    private transient ServletContext context;

    public VaadinServletContext(ServletContext context) {
        this.context = context;
    }

    public ServletContext getContext() {
        return this.context;
    }

    private void ensureServletContext() {
        if (this.context == null && VaadinService.getCurrent() instanceof VaadinServletService) {
            this.context = ((VaadinServletService)VaadinService.getCurrent()).getServlet().getServletContext();
        } else if (this.context == null) {
            throw new IllegalStateException("The underlying ServletContext of VaadinServletContext is null and there is no VaadinServletService to obtain it from.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getAttribute(Class<T> type, Supplier<T> defaultValueSupplier) {
        this.ensureServletContext();
        VaadinServletContext vaadinServletContext = this;
        synchronized (vaadinServletContext) {
            Object result = this.context.getAttribute(type.getName());
            if (result == null && defaultValueSupplier != null) {
                result = defaultValueSupplier.get();
                this.context.setAttribute(type.getName(), result);
            }
            return type.cast(result);
        }
    }

    @Override
    public <T> void setAttribute(Class<T> clazz, T value) {
        if (value == null) {
            this.removeAttribute(clazz);
        } else {
            this.ensureServletContext();
            this.context.setAttribute(clazz.getName(), value);
        }
    }

    @Override
    public void removeAttribute(Class<?> clazz) {
        this.ensureServletContext();
        this.context.removeAttribute(clazz.getName());
    }

    @Override
    public Enumeration<String> getContextParameterNames() {
        this.ensureServletContext();
        return this.context.getInitParameterNames();
    }

    @Override
    public String getContextParameter(String name) {
        this.ensureServletContext();
        return this.context.getInitParameter(name);
    }
}

