/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.server.AmbiguousRouteConfigurationException;
import com.vaadin.flow.server.InvalidRouteConfigurationException;
import com.vaadin.flow.server.VaadinServletContext;
import com.vaadin.flow.server.startup.AbstractRouteRegistryInitializer;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import com.vaadin.flow.server.startup.ClassLoaderAwareServletContainerInitializer;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;

@HandlesTypes(value={Route.class, RouteAlias.class})
public class RouteRegistryInitializer
extends AbstractRouteRegistryInitializer
implements ClassLoaderAwareServletContainerInitializer {
    @Override
    public void process(Set<Class<?>> classSet, ServletContext servletContext) throws ServletException {
        VaadinServletContext context = new VaadinServletContext(servletContext);
        try {
            if (classSet == null) {
                ApplicationRouteRegistry routeRegistry = ApplicationRouteRegistry.getInstance(context);
                routeRegistry.clean();
                return;
            }
            Set<Class<? extends Component>> routes = this.validateRouteClasses(classSet.stream());
            ApplicationRouteRegistry routeRegistry = ApplicationRouteRegistry.getInstance(context);
            RouteConfiguration routeConfiguration = RouteConfiguration.forRegistry(routeRegistry);
            routeConfiguration.update(() -> this.setAnnotatedRoutes(routeConfiguration, routes));
            routeRegistry.setPwaConfigurationClass(this.validatePwaClass(routes.stream().map(clazz -> clazz)));
        }
        catch (InvalidRouteConfigurationException irce) {
            throw new ServletException("Exception while registering Routes on servlet startup", (Throwable)irce);
        }
    }

    private void setAnnotatedRoutes(RouteConfiguration routeConfiguration, Set<Class<? extends Component>> routes) {
        routeConfiguration.getHandledRegistry().clean();
        for (Class<? extends Component> navigationTarget : routes) {
            try {
                routeConfiguration.setAnnotatedRoute(navigationTarget);
            }
            catch (AmbiguousRouteConfigurationException exception) {
                if (this.handleAmbiguousRoute(routeConfiguration, exception.getConfiguredNavigationTarget(), navigationTarget)) continue;
                throw exception;
            }
        }
    }

    private boolean handleAmbiguousRoute(RouteConfiguration routeConfiguration, Class<? extends Component> configuredNavigationTarget, Class<? extends Component> navigationTarget) {
        if (GenericTypeReflector.isSuperType(navigationTarget, configuredNavigationTarget)) {
            return true;
        }
        if (GenericTypeReflector.isSuperType(configuredNavigationTarget, navigationTarget)) {
            routeConfiguration.removeRoute(configuredNavigationTarget);
            routeConfiguration.setAnnotatedRoute(navigationTarget);
            return true;
        }
        return false;
    }
}

