/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import java.util.function.Predicate;

public class PropertyFilter
implements Predicate<String> {
    private final String prefix;
    private final Predicate<String> predicate;
    public static final PropertyFilter ACCEPT_ALL = new PropertyFilter(name -> true);

    public PropertyFilter(Predicate<String> predicate) {
        this("", predicate);
    }

    public PropertyFilter(PropertyFilter outerFilter, String scopeName, Predicate<String> predicate) {
        this(PropertyFilter.composePrefix(outerFilter, scopeName), predicate.and(PropertyFilter.composeFilter(outerFilter, scopeName)));
    }

    public PropertyFilter(PropertyFilter outerFilter, String scopeName) {
        this(outerFilter, scopeName, name -> true);
    }

    private PropertyFilter(String prefix, Predicate<String> predicate) {
        assert (predicate != null);
        assert (prefix != null);
        assert (prefix.isEmpty() || prefix.endsWith("."));
        assert (!prefix.startsWith("."));
        this.prefix = prefix;
        this.predicate = predicate;
    }

    private static String composePrefix(PropertyFilter outerFilter, String scopeName) {
        assert (scopeName != null);
        assert (!scopeName.isEmpty());
        assert (!scopeName.contains("."));
        return outerFilter.prefix + scopeName + ".";
    }

    private static Predicate<? super String> composeFilter(PropertyFilter outerFilter, String scopeName) {
        return name -> outerFilter.test(scopeName + "." + name);
    }

    @Override
    public boolean test(String propertyName) {
        return this.predicate.test(propertyName);
    }

    public String getPrefix() {
        return this.prefix;
    }
}

