/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.conversion.TypeConverter;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public abstract class SArray
implements Array {
    protected static final int RETRIEVE_ALL_DATA = -1;
    private IArray m_array;
    private IConnection m_parentConnection;
    private ILogger m_logger;
    private IWarningListener m_warningListener;

    public SArray(IArray array, IConnection conn, ILogger logger, IWarningListener warningListener) {
        this.m_array = array;
        this.m_parentConnection = conn;
        this.m_logger = logger;
        this.m_warningListener = warningListener;
    }

    @Override
    public Object getArray() throws SQLException {
        try {
            return this.createArray(1L, -1);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(Map)");
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        try {
            return this.createArray(index, count);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener());
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getArray(long,int,Map)");
    }

    @Override
    public int getBaseType() throws SQLException {
        try {
            TypeMetadata typeMetadata = this.m_array.getBaseColumn().getTypeMetadata();
            return TypeUtilities.mapDataTypes(typeMetadata.getType());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return this.m_array.getBaseColumn().getTypeMetadata().getTypeName();
    }

    public final int getUnmappedBaseType() throws SQLException {
        try {
            return this.m_array.getBaseColumn().getTypeMetadata().getType();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.createResultSet(1L, -1);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(Map)");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        try {
            return this.createResultSet(index, count);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.FEATURE_NOT_SUPPORTED, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, "getResultSet(long,int,Map)");
    }

    @Override
    public void free() throws SQLException {
        try {
            this.m_array.free();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    public String toString() {
        return this.getDSIArray().getStringRepresentation();
    }

    protected Object createArray(long index, int count) throws SQLException {
        try {
            Object array = this.getDSIArray().createArray(index - 1L, count);
            if (2003 == this.getBaseType()) {
                int nesting = TypeUtilities.getDimensionofArray(this.getDSIArray());
                Object sArray = this.createArrayHelper(nesting, index, count, array);
                return sArray;
            }
            return array;
        }
        catch (ErrorException err) {
            throw ExceptionConverter.getInstance().toSQLException(err, this.getWarningListener());
        }
    }

    protected abstract ResultSet createResultSet(long var1, int var3) throws SQLException;

    public IArray getDSIArray() {
        return this.m_array;
    }

    protected ILogger getLogger() {
        return this.m_logger;
    }

    protected IConnection getParentConnection() {
        return this.m_parentConnection;
    }

    protected IWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    protected Object createArrayHelper(int nesting, long index, int count, Object array) throws SQLException, ErrorException {
        Object[] returnArray;
        if (nesting == 0) {
            try {
                returnArray = TypeConverter.convertToObjectArray(array);
            }
            catch (IncorrectTypeException e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener());
            }
        } else {
            IArray[] dsiArrays = (IArray[])array;
            int len = dsiArrays.length;
            returnArray = new Object[len];
            for (int i = 0; i < len; ++i) {
                Object subIArray = dsiArrays[i].createArray(index - 1L, count);
                returnArray[i] = this.createArrayHelper(nesting - 1, index, count, subIArray);
            }
        }
        return returnArray;
    }
}

