/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SCallableStatement;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.jdbc41.S41Array;
import com.vertica.jdbc.jdbc41.S41ForwardResultSet;
import com.vertica.jdbc.jdbc41.S41ParameterMetaData;
import com.vertica.jdbc.jdbc41.S41ResultSetMetaData;
import com.vertica.jdbc.jdbc41.S41UpdatableForwardResultSet;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.JDBCVersion;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class S41CallableStatement
extends SCallableStatement {
    public S41CallableStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(sql, statement, conn, concurrency);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    protected ResultSet createResultSet(IResultSet internalResultSet, boolean updatable, int fetchSize) throws SQLException {
        SForwardResultSet resultSet = updatable ? new S41UpdatableForwardResultSet(this, internalResultSet, this.getLogger()) : new S41ForwardResultSet(this, internalResultSet, this.getLogger());
        resultSet.setFetchSize(fetchSize);
        return resultSet;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getResultSetMetaData()) {
                IResults execResults = this.getQueryExecutor().getResults();
                Iterator<ExecutionResult> itr = execResults.getResultItr();
                if (!itr.hasNext()) {
                    return null;
                }
                ExecutionResult execResult = itr.next();
                if (itr.hasNext()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_METADATA, (IWarningListener)this.getWarningListener(), ExceptionType.DEFAULT, new Object[0]);
                }
                if (ExecutionResultType.RESULT_SET == execResult.getType()) {
                    IResultSet result = (IResultSet)execResult.getResult();
                    this.setResultSetMetadata(this.createResultSetMetaData(result));
                }
            }
            return this.getResultSetMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    protected SResultSetMetaData createResultSetMetaData(IResultSet internalResultSet) throws SQLException {
        try {
            ArrayList<? extends IColumn> metadataColumns = internalResultSet.getSelectColumns();
            if (null == metadataColumns) {
                return null;
            }
            return new S41ResultSetMetaData(metadataColumns, this.getLogger(), this.getWarningListener());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            if (null == this.getOpenParamMetaData()) {
                S41ParameterMetaData parameterMetadata = null;
                parameterMetadata = new S41ParameterMetaData(this.getParameterMetadataList(), this.getLogger(), this.getWarningListener());
                this.setOpenParamMetaData(parameterMetadata);
            }
            return this.getOpenParamMetaData();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, type);
            this.checkIfOpen();
            if (type.equals(BigDecimal.class)) {
                return (T)this.getBigDecimal(parameterIndex);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(this.getBoolean(parameterIndex));
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return (T)Byte.valueOf(this.getByte(parameterIndex));
            }
            if (type.equals(byte[].class)) {
                return (T)this.getBytes(parameterIndex);
            }
            if (type.equals(Date.class)) {
                return (T)this.getDate(parameterIndex);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return (T)Double.valueOf(this.getDouble(parameterIndex));
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return (T)Float.valueOf(this.getFloat(parameterIndex));
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(this.getInt(parameterIndex));
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return (T)Long.valueOf(this.getLong(parameterIndex));
            }
            if (type.equals(Object.class)) {
                return (T)this.getObject(parameterIndex);
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return (T)Short.valueOf(this.getShort(parameterIndex));
            }
            if (type.equals(String.class)) {
                return (T)this.getString(parameterIndex);
            }
            if (type.equals(Time.class)) {
                return (T)this.getTime(parameterIndex);
            }
            if (type.equals(Timestamp.class)) {
                return (T)this.getTimestamp(parameterIndex);
            }
            if (type.equals(Array.class) || type.equals(Blob.class) || type.equals(Clob.class) || type.equals(Ref.class) || type.equals(URL.class) || type.equals(NClob.class) || type.equals(RowId.class) || type.equals(SQLXML.class)) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(parameterIndex), type.getName());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterName, type);
        return this.getObject(this.getParameterIndex(parameterName), type);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex);
            this.checkIfOpen();
            DataWrapper data = this.getOutputParameterValue(parameterIndex);
            IConnection con = this.getParentConnection().getConnection();
            return new S41Array(data.getArray(), con, this.m_logger, this.m_warningListener);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }
}

