/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.parser;

import com.vertica.parser.ParsedStatement;
import com.vertica.parser.Quote;
import com.vertica.parser.Token;
import com.vertica.parser.Tokenizer;
import com.vertica.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;

public final class ParsedQuery {
    private ArrayList<ParsedStatement> m_statements;
    private String m_sqlText;
    private boolean m_useStandardStrings;
    private int m_maxRows;
    private static final HashMap<Token, Token> SCALAR_FUNCTION_REWRITES;
    private static final HashMap<Token, Token> CONVERT_FUNCTION_REWRITES;

    public ParsedQuery(String string, boolean bl) {
        this.m_sqlText = string;
        this.m_useStandardStrings = bl;
        this.m_statements = new ArrayList();
    }

    public ParsedQuery(String string, boolean bl, int n) {
        this.m_maxRows = n;
        this.m_sqlText = string;
        this.m_useStandardStrings = bl;
        this.m_statements = new ArrayList();
    }

    public void parse() throws ErrorException {
        Tokenizer tokenizer = new Tokenizer(this.m_sqlText, this.m_useStandardStrings);
        ParsedStatement parsedStatement = null;
        Token token = null;
        ArrayList<Token> arrayList = new ArrayList<Token>(100);
        int n = 0;
        Stack<EscapeSequence> stack = new Stack<EscapeSequence>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while ((token = tokenizer.next()) != null) {
            Object object;
            if (token.equals(Token.ESCAPE_SEQ_BEGIN)) {
                arrayList.add(Token.ESCAPE_SEQ_REPLACEMENT);
                token = tokenizer.next();
                if (token != null) {
                    object = tokenizer.peek();
                    stack.push(new EscapeSequence(token, (Token)object));
                    if (!token.equals(Token.LIKE_ESCAPE_KEYWORD)) {
                        token = tokenizer.next();
                    }
                }
            } else if (token.equals(Token.ESCAPE_SEQ_END) && !stack.isEmpty()) {
                object = (EscapeSequence)stack.pop();
                Token token2 = this.checkForDateTimeEscape((EscapeSequence)object);
                token = token2 != null ? token2 : tokenizer.next();
                arrayList.add(Token.ESCAPE_SEQ_REPLACEMENT);
            }
            if (token != null) {
                if (!stack.isEmpty()) {
                    token = this.checkForEscapeFunction((EscapeSequence)stack.peek(), token);
                }
                if (token.equals(Token.SELECT) && arrayList.isEmpty()) {
                    bl2 = true;
                }
                if (token.equals(Token.FROM)) {
                    bl3 = true;
                }
                if (token.equals(Token.LIMIT)) {
                    bl = true;
                }
                if (!token.equals(Token.SEMICOLON)) {
                    arrayList.add(token);
                } else {
                    bl4 = true;
                }
                if (token.equals(Token.PARAMETER_MARKER)) {
                    ++n;
                }
            }
            if (token == null || tokenizer.peek() == null && !token.equals(Token.SEMICOLON)) {
                token = Token.SEMICOLON;
            }
            if (!token.equals(Token.SEMICOLON)) continue;
            if (this.m_maxRows > 0 && bl2 && bl3 && !bl) {
                arrayList.add(new Token(" ", Quote.NO_QUOTES, ""));
                arrayList.add(Token.LIMIT);
                arrayList.add(new Token(Integer.toString(this.m_maxRows), Quote.NO_QUOTES, " "));
            }
            if (bl4) {
                arrayList.add(token);
            }
            parsedStatement = new ParsedStatement(arrayList, n);
            arrayList = new ArrayList();
            n = 0;
            bl2 = false;
            bl = false;
            bl4 = false;
            this.m_statements.add(parsedStatement);
        }
        if (this.m_statements.isEmpty()) {
            this.m_statements.add(new ParsedStatement(new ArrayList<Token>(), 0));
        }
    }

    private Token checkForEscapeFunction(EscapeSequence escapeSequence, Token token) {
        if (escapeSequence.type.equals(Token.ESCAPE_FN)) {
            Token token2 = SCALAR_FUNCTION_REWRITES.get(token);
            if (token2 != null) {
                return token2;
            }
            if (escapeSequence.subtype.equals(Token.CONVERT)) {
                Token token3 = CONVERT_FUNCTION_REWRITES.get(token);
                return token3 == null ? token : token3;
            }
        }
        return token;
    }

    private Token checkForDateTimeEscape(EscapeSequence escapeSequence) {
        if (escapeSequence.type.equals(Token.ESCAPE_DATE)) {
            return Token.DATE_CAST;
        }
        if (escapeSequence.type.equals(Token.ESCAPE_TIME)) {
            return Token.TIME_CAST;
        }
        if (escapeSequence.type.equals(Token.ESCAPE_TIMESTAMP)) {
            return Token.TIMESTAMP_CAST;
        }
        return null;
    }

    public int getStatementCount() {
        return this.m_statements.size();
    }

    public ParsedStatement getStatement(int n) {
        return this.m_statements.get(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ParsedStatement parsedStatement = null;
        for (int i = 0; i < this.m_statements.size(); ++i) {
            parsedStatement = this.m_statements.get(i);
            stringBuilder.append(parsedStatement.toString());
            if (i == this.m_statements.size() - 1) continue;
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    static {
        String[] stringArray;
        SCALAR_FUNCTION_REWRITES = new HashMap();
        Quote quote = Quote.NO_QUOTES;
        String string = "";
        SCALAR_FUNCTION_REWRITES.put(new Token("database", quote, string), new Token("dbname", quote, string));
        SCALAR_FUNCTION_REWRITES.put(new Token("lcase", quote, string), new Token("lower", quote, string));
        SCALAR_FUNCTION_REWRITES.put(new Token("ucase", quote, string), new Token("upper", quote, string));
        SCALAR_FUNCTION_REWRITES.put(new Token("curdate", quote, string), new Token("current_date", quote, string));
        SCALAR_FUNCTION_REWRITES.put(new Token("curtime", quote, string), new Token("current_time", quote, string));
        SCALAR_FUNCTION_REWRITES.put(new Token("convert", quote, string), new Token("cast", quote, string));
        CONVERT_FUNCTION_REWRITES = new HashMap();
        for (String string2 : stringArray = new String[]{"BIGINT", "BINARY", "BIT", "BOOLEAN", "CHAR", "DECIMAL", "DOUBLE", "FLOAT", "INTEGER", "LONGVARBINARY", "LONGVARCHAR", "NULL", "NUMERIC", "REAL", "SMALLINT", "TIME", "TIMESTAMP", "TINYINT", "VARBINARY", "VARCHAR", "INTERVAL_DAY", "INTERVAL_DAY_TO_HOUR", "INTERVAL_DAY_TO_MINUTE", "INTERVAL_DAY_TO_SECOND", "INTERVAL_HOUR", "INTERVAL_HOUR_TO_MINUTE", "INTERVAL_HOUR_TO_SECOND", "INTERVAL_MINUTE", "INTERVAL_MINUTE_TO_SECOND", "INTERVAL_SECOND", "INTERVAL_MONTH", "INTERVAL_YEAR", "INTERVAL_YEAR_TO_MONTH"}) {
            String string3 = string2.replace("_", " ");
            if (string3.equals("DOUBLE")) {
                string3 = "DOUBLE PRECISION";
            } else if (string3.equals("BIT")) {
                string3 = "BOOLEAN";
            } else if (string3.equals("LONGVARCHAR")) {
                string3 = "LONG VARCHAR";
            } else if (string3.equals("LONGVARBINARY")) {
                string3 = "LONG VARBINARY";
            }
            CONVERT_FUNCTION_REWRITES.put(new Token(string2, quote, string), new Token(string3, quote, string));
            CONVERT_FUNCTION_REWRITES.put(new Token("SQL_" + string2, quote, string), new Token(string3, quote, string));
        }
        CONVERT_FUNCTION_REWRITES.put(new Token(",", quote, ""), new Token(" as ", quote, ""));
    }

    private static class EscapeSequence {
        Token type;
        Token subtype;

        private EscapeSequence(Token token, Token token2) {
            this.type = token;
            this.subtype = token2;
        }
    }
}

