/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.thrift;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TException;
import com.facebook.thrift.protocol.TBinaryProtocol;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolFactory;
import com.facebook.thrift.transport.TIOStreamTransport;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class TSerializer {
    private final TProtocolFactory protocolFactory;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public byte[] serialize(TBase base) throws TException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TIOStreamTransport transport = new TIOStreamTransport(byteArrayOutputStream);
        TProtocol protocol = this.protocolFactory.getProtocol(transport);
        base.write(protocol);
        return byteArrayOutputStream.toByteArray();
    }

    public String toString(TBase base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public String toString(TBase base) throws TException {
        return new String(this.serialize(base));
    }
}

