/*
 * Decompiled with CFR 0.152.
 */
package com.volcengine.ark.runtime.model.files;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.volcengine.ark.runtime.exception.ArkAPIError;
import com.volcengine.ark.runtime.model.files.PreprocessConfigs;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileMeta {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="bytes")
    private Integer bytes;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String createdTime;
    @JsonProperty(value="expire_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String expireTime;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="purpose")
    private String purpose;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="error")
    private ArkAPIError.ArkErrorDetails error;
    @JsonProperty(value="preprocess_configs")
    private PreprocessConfigs preprocessConfigs;

    public String toString() {
        return "FileMeta{id='" + this.id + '\'' + ", object='" + this.object + '\'' + ", bytes=" + this.bytes + ", createdTime='" + this.createdTime + '\'' + ", expireTime='" + this.expireTime + '\'' + ", filename='" + this.filename + '\'' + ", purpose='" + this.purpose + '\'' + ", status='" + this.status + '\'' + ", error=" + this.error + ", preprocessConfigs=" + this.preprocessConfigs + '}';
    }

    public String getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public Integer getBytes() {
        return this.bytes;
    }

    public void setBytes(Integer bytes) {
        this.bytes = bytes;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ArkAPIError.ArkErrorDetails getError() {
        return this.error;
    }

    public void setError(ArkAPIError.ArkErrorDetails error) {
        this.error = error;
    }

    public PreprocessConfigs getPreprocessConfigs() {
        return this.preprocessConfigs;
    }

    public void setPreprocessConfigs(PreprocessConfigs preprocessConfigs) {
        this.preprocessConfigs = preprocessConfigs;
    }

    public static final class FileBuilder {
        private String id;
        private String object;
        private Integer bytes;
        private String createdTime;
        private String expireTime;
        private String filename;
        private String purpose;
        private String status;
        private ArkAPIError.ArkErrorDetails error;
        private PreprocessConfigs preprocessConfigs;

        private FileBuilder() {
        }

        public static FileBuilder aFile() {
            return new FileBuilder();
        }

        public FileBuilder id(String id) {
            this.id = id;
            return this;
        }

        public FileBuilder object(String object) {
            this.object = object;
            return this;
        }

        public FileBuilder bytes(Integer bytes) {
            this.bytes = bytes;
            return this;
        }

        public FileBuilder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public FileBuilder expireTime(String expireTime) {
            this.expireTime = expireTime;
            return this;
        }

        public FileBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        public FileBuilder purpose(String purpose) {
            this.purpose = purpose;
            return this;
        }

        public FileBuilder status(String status) {
            this.status = status;
            return this;
        }

        public FileBuilder error(ArkAPIError.ArkErrorDetails error) {
            this.error = error;
            return this;
        }

        public FileBuilder preprocessConfigs(PreprocessConfigs preprocessConfigs) {
            this.preprocessConfigs = preprocessConfigs;
            return this;
        }

        public FileMeta build() {
            FileMeta fileMeta = new FileMeta();
            fileMeta.setId(this.id);
            fileMeta.setObject(this.object);
            fileMeta.setBytes(this.bytes);
            fileMeta.setCreatedTime(this.createdTime);
            fileMeta.setExpireTime(this.expireTime);
            fileMeta.setFilename(this.filename);
            fileMeta.setPurpose(this.purpose);
            fileMeta.setStatus(this.status);
            fileMeta.setError(this.error);
            fileMeta.setPreprocessConfigs(this.preprocessConfigs);
            return fileMeta;
        }
    }
}

