/*
 * Decompiled with CFR 0.152.
 */
package com.wix.mysql.config;

import com.wix.mysql.config.AdditionalConfig;
import de.flapdoodle.embed.process.config.store.IProxyFactory;
import de.flapdoodle.embed.process.config.store.NoProxyFactory;
import java.io.File;

public class DownloadConfig
implements AdditionalConfig {
    private final String cacheDir;
    private final String baseUrl;
    private final IProxyFactory proxyFactory;

    private DownloadConfig(String cacheDir, String baseUrl, IProxyFactory proxy) {
        this.cacheDir = cacheDir;
        this.baseUrl = baseUrl;
        this.proxyFactory = proxy;
    }

    public IProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Deprecated
    public String getDownloadCacheDir() {
        return this.cacheDir;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public static Builder aDownloadConfig() {
        return new Builder();
    }

    public static class Builder {
        private IProxyFactory proxyFactory = new NoProxyFactory();
        private String cacheDir = new File(System.getProperty("user.home"), ".embedmysql").getPath();
        private String baseUrl = "https://dev.mysql.com/get/Downloads/";

        @Deprecated
        public Builder withDownloadCacheDir(String downloadCacheDir) {
            this.cacheDir = downloadCacheDir;
            return this;
        }

        public Builder withCacheDir(String cacheDir) {
            this.cacheDir = cacheDir;
            return this;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withProxy(IProxyFactory proxy) {
            this.proxyFactory = proxy;
            return this;
        }

        public DownloadConfig build() {
            return new DownloadConfig(this.cacheDir, this.baseUrl, this.proxyFactory);
        }
    }
}

