/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.gm.base.security.digest;

import com.google.common.collect.Maps;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.gm.base.utils.SmUtils;
import com.yeepay.yop.sdk.security.DigestAlgEnum;
import com.yeepay.yop.sdk.security.digest.YopDigester;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YopSm3Digester
implements YopDigester {
    private static final Logger LOGGER = LoggerFactory.getLogger(YopSm3Digester.class);
    private final ThreadLocal<Map<String, MessageDigest>> MESSAGE_DIGEST = ThreadLocal.withInitial(YopSm3Digester::initMdInstance);

    public List<String> supportedAlgs() {
        return Collections.singletonList(DigestAlgEnum.SM3.name());
    }

    public byte[] digest(InputStream input, String alg) {
        try {
            MessageDigest md = this.getMessageDigestInstance(alg);
            DigestInputStream digestInputStream = new DigestInputStream(input, md);
            byte[] buffer = new byte[1024];
            while (digestInputStream.read(buffer) > -1) {
            }
            return digestInputStream.getMessageDigest().digest();
        }
        catch (Exception e) {
            throw new YopClientException("UnexpectedError, MessageDigest Fail, alg:" + alg + ", ex:", (Throwable)e);
        }
    }

    protected static Map<String, MessageDigest> initMdInstance() {
        try {
            HashMap algMap = Maps.newHashMap();
            algMap.put("SM3", MessageDigest.getInstance("SM3", "BC"));
            return algMap;
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get Digest Function, will fail when use YopSm2Signer for sign, ex", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private MessageDigest getMessageDigestInstance(String digestAlg) {
        MessageDigest messageDigest = this.MESSAGE_DIGEST.get().get(digestAlg);
        messageDigest.reset();
        return messageDigest;
    }

    static {
        SmUtils.init();
    }
}

