/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.invoke;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.exception.YopBlockException;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.invoke.model.AnalyzedException;
import com.yeepay.yop.sdk.invoke.model.ExceptionAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SimpleExceptionAnalyzer
implements ExceptionAnalyzer<AnalyzedException> {
    private final Set<String> excludeExceptions;
    private final Set<String> retryExceptions;

    public SimpleExceptionAnalyzer(Set<String> excludeExceptions, Set<String> retryExceptions) {
        this.excludeExceptions = null != excludeExceptions ? excludeExceptions : Collections.emptySet();
        this.retryExceptions = null != retryExceptions ? retryExceptions : Collections.emptySet();
    }

    public AnalyzedException analyze(Throwable e, Object ... args) {
        AnalyzedException result = new AnalyzedException();
        result.setException(e);
        if (e instanceof YopClientException) {
            result.setExDetail(e.getClass().getCanonicalName() + ":" + StringUtils.defaultString((String)e.getMessage()));
            return result;
        }
        if (e instanceof YopBlockException) {
            result.setExDetail(e.getClass().getCanonicalName() + ":" + StringUtils.defaultString((String)e.getMessage()));
            result.setNeedRetry(true);
            result.setBlocked(true);
            return result;
        }
        Throwable[] allExceptions = ExceptionUtils.getThrowables((Throwable)e);
        ArrayList exceptionDetails = Lists.newArrayList();
        for (int i = 0; i < allExceptions.length; ++i) {
            Throwable rootCause = allExceptions[i];
            String exType = rootCause.getClass().getCanonicalName();
            String exTypeAndMsg = exType + ":" + StringUtils.defaultString((String)rootCause.getMessage());
            exceptionDetails.add(exType);
            exceptionDetails.add(exTypeAndMsg);
            if (!this.retryExceptions.contains(exType) && !this.retryExceptions.contains(exTypeAndMsg)) continue;
            result.setExDetail(exTypeAndMsg);
            result.setNeedRetry(true);
            result.setNeedDegrade(true);
            return result;
        }
        Throwable lastCause = allExceptions[allExceptions.length - 1];
        result.setExDetail(lastCause.getClass().getCanonicalName() + ":" + StringUtils.defaultString((String)lastCause.getMessage()));
        if (CollectionUtils.containsAny(this.excludeExceptions, (Collection)exceptionDetails)) {
            return result;
        }
        result.setNeedDegrade(true);
        return result;
    }
}

