/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.invoke;

import com.google.common.collect.Lists;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.exception.YopUnknownException;
import com.yeepay.yop.sdk.invoke.Invoker;
import com.yeepay.yop.sdk.invoke.Router;
import com.yeepay.yop.sdk.invoke.UriRouteInvoker;
import com.yeepay.yop.sdk.invoke.model.AnalyzedException;
import com.yeepay.yop.sdk.invoke.model.RetryContext;
import com.yeepay.yop.sdk.invoke.model.RetryPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriRouteInvokerWrapper<Input, Output, Context extends RetryContext, Policy extends RetryPolicy, Exception extends AnalyzedException>
implements Invoker<Input, Output, Context, Exception> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UriRouteInvokerWrapper.class);
    private UriRouteInvoker<Input, Output, Context, Exception> invoker;
    private RetryPolicy retryPolicy;
    private Router<URI, Input, Context> uriRouter;

    public UriRouteInvokerWrapper(UriRouteInvoker<Input, Output, Context, Exception> invoker, RetryPolicy retryPolicy, Router<URI, Input, Context> uriRouter) {
        this.invoker = invoker;
        this.retryPolicy = retryPolicy;
        this.uriRouter = uriRouter;
    }

    public Output invoke() {
        long start = System.currentTimeMillis();
        ArrayList excludeServerRoots = Lists.newArrayList();
        URI lastServerRoot = (URI)this.uriRouter.route(this.getInput(), this.getContext(), new Object[]{excludeServerRoots});
        while (!excludeServerRoots.contains(lastServerRoot)) {
            try {
                this.invoker.setUri(lastServerRoot);
                Object result = this.invoker.invoke();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Success ServerRoot, {}, elapsed:{}, retryCount:{}", new Object[]{this.invoker.getUri(), System.currentTimeMillis() - start, this.getContext().retryCount()});
                }
                return (Output)result;
            }
            catch (Throwable throwable) {
                if (throwable instanceof YopClientException) {
                    throw throwable;
                }
                AnalyzedException analyzedEx = this.invoker.getLastException();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Fail ServerRoot, {}, exDetail:{}, elapsed:{}", new Object[]{this.invoker.getUri(), analyzedEx.getExDetail(), System.currentTimeMillis() - start});
                }
                if (analyzedEx.isNeedRetry() && null != this.retryPolicy && this.retryPolicy.allowRetry(new Object[]{this.invoker, throwable})) {
                    excludeServerRoots.add(lastServerRoot);
                    this.getContext().markRetried(new Object[]{1});
                    lastServerRoot = (URI)this.uriRouter.route(this.getInput(), this.getContext(), new Object[]{excludeServerRoots});
                    continue;
                }
                if (analyzedEx.isNeedDegrade()) {
                    this.handleUnExpectedError(throwable);
                }
                throw new YopClientException("Client Error, ex:", throwable);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("All ServerRoots Unavailable, Last Try, tried:{}, last:{}", (Object)excludeServerRoots, (Object)lastServerRoot);
        }
        this.invoker.setUri(lastServerRoot);
        this.invoker.disableCircuitBreaker();
        return (Output)this.invoker.invoke();
    }

    private void handleUnExpectedError(Throwable ex) {
        if (ex instanceof YopUnknownException) {
            throw (YopUnknownException)ex;
        }
        throw new YopUnknownException("UnExpected Error, ", ex);
    }

    public Input getInput() {
        return (Input)this.invoker.getInput();
    }

    public void setInput(Input input) {
        this.invoker.setInput(input);
    }

    public void setContext(Context context) {
        this.invoker.setContext(context);
    }

    public Context getContext() {
        return (Context)((RetryContext)this.invoker.getContext());
    }

    public List<Exception> getExceptions() {
        return this.invoker.getExceptions();
    }

    public void addException(Exception exception) {
        this.invoker.addException(exception);
    }

    public Exception getLastException() {
        return (Exception)this.invoker.getLastException();
    }
}

