/*
 * Decompiled with CFR 0.152.
 */
package com.openapi.sdk.sign;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HS256Util {
    private static final String HMAC_SHA256 = "HmacSHA256";

    public static String generateSignature(String data, String secret) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec secretKeySpec = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), HMAC_SHA256);
        Mac mac = Mac.getInstance(HMAC_SHA256);
        mac.init(secretKeySpec);
        byte[] signatureBytes = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(signatureBytes);
    }

    public static boolean verifySignature(String data, String secret, String signature) throws NoSuchAlgorithmException, InvalidKeyException {
        String generatedSignature = HS256Util.generateSignature(data, secret);
        return generatedSignature.equals(signature);
    }

    public static void main(String[] args) {
        try {
            String data = "Hello, HS256!";
            String secret = "mySecretKey123";
            String signature = HS256Util.generateSignature(data, secret);
            System.out.println("\u751f\u6210\u7684HS256\u7b7e\u540d: " + signature);
            boolean isValid = HS256Util.verifySignature(data, secret, signature);
            System.out.println("\u7b7e\u540d\u9a8c\u8bc1\u7ed3\u679c: " + (isValid ? "\u6709\u6548" : "\u65e0\u6548"));
            String tamperedData = "Hello, HS256! Tampered";
            boolean isTamperedValid = HS256Util.verifySignature(tamperedData, secret, signature);
            System.out.println("\u7be1\u6539\u6570\u636e\u540e\u7684\u9a8c\u8bc1\u7ed3\u679c: " + (isTamperedValid ? "\u6709\u6548" : "\u65e0\u6548"));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

