/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.Assert;

public class Application {
    private final String name;
    private final String managementUrl;
    private final String healthUrl;
    private final String serviceUrl;
    private final Map<String, String> metadata;

    protected Application(Builder builder) {
        Assert.hasText((String)builder.name, (String)"name must not be empty!");
        Assert.hasText((String)builder.healthUrl, (String)"healthUrl must not be empty!");
        this.healthUrl = builder.healthUrl;
        this.managementUrl = builder.managementUrl;
        this.serviceUrl = builder.serviceUrl;
        this.name = builder.name;
        this.metadata = Collections.unmodifiableMap(new HashMap(builder.metadata));
    }

    public static Builder create(String name) {
        return new Builder(name);
    }

    public String getName() {
        return this.name;
    }

    public String getManagementUrl() {
        return this.managementUrl;
    }

    public String getHealthUrl() {
        return this.healthUrl;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Application [name=" + this.name + ", managementUrl=" + this.managementUrl + ", healthUrl=" + this.healthUrl + ", serviceUrl=" + this.serviceUrl + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.healthUrl == null ? 0 : this.healthUrl.hashCode());
        result = 31 * result + (this.managementUrl == null ? 0 : this.managementUrl.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serviceUrl == null ? 0 : this.serviceUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Application other = (Application)obj;
        if (this.healthUrl == null ? other.healthUrl != null : !this.healthUrl.equals(other.healthUrl)) {
            return false;
        }
        if (this.managementUrl == null ? other.managementUrl != null : !this.managementUrl.equals(other.managementUrl)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.serviceUrl == null ? other.serviceUrl != null : !this.serviceUrl.equals(other.serviceUrl));
    }

    public static class Builder {
        private String name;
        private String managementUrl;
        private String healthUrl;
        private String serviceUrl;
        private Map<String, String> metadata = new HashMap<String, String>();

        private Builder(String name) {
            this.name = name;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withServiceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public Builder withHealthUrl(String healthUrl) {
            this.healthUrl = healthUrl;
            return this;
        }

        public Builder withManagementUrl(String managementUrl) {
            this.managementUrl = managementUrl;
            return this;
        }

        public Builder withMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder withMetadata(Map<String, String> metadata) {
            this.metadata.putAll(metadata);
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }
}

