/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.buildtimestamp.svn;

import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.tycho.buildversion.BuildTimestampProvider;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNInfoHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNWCClient;

@Component(role=BuildTimestampProvider.class, hint="svn")
public class SvnBuildTimestampProvider
implements BuildTimestampProvider {
    public Date getTimestamp(MavenSession session, MavenProject project, MojoExecution execution) throws MojoExecutionException {
        SVNClientManager clientManager = SVNClientManager.newInstance();
        SVNWCClient wcClient = clientManager.getWCClient();
        String ignoreFilter = this.getIgnoreFilter(execution);
        final Date[] result = new Date[]{null};
        final HashSet<String> filterFiles = new HashSet<String>();
        if (ignoreFilter != null) {
            StringTokenizer tokens = new StringTokenizer(ignoreFilter, "\n\r\f");
            while (tokens.hasMoreTokens()) {
                filterFiles.add(tokens.nextToken());
            }
        }
        try {
            wcClient.doInfo(project.getBasedir(), null, null, SVNDepth.INFINITY, null, new ISVNInfoHandler(){

                public void handleInfo(SVNInfo info) throws SVNException {
                    File file = info.getFile();
                    if (filterFiles.contains(file.getName())) {
                        return;
                    }
                    Date date = info.getCommittedDate();
                    if (result[0] == null || date.after(result[0])) {
                        result[0] = date;
                    }
                }
            });
        }
        catch (SVNException e) {
            throw new MojoExecutionException("Failed to get info", (Exception)((Object)e));
        }
        return result[0];
    }

    private String getIgnoreFilter(MojoExecution execution) {
        String result = null;
        Xpp3Dom pluginConfiguration = (Xpp3Dom)execution.getPlugin().getConfiguration();
        Xpp3Dom ignoreDom = pluginConfiguration.getChild("svn.ignore");
        if (ignoreDom != null) {
            result = ignoreDom.getValue();
        }
        return result;
    }
}

