/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import dev.ai4j.openai4j.Json;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.Message;
import java.io.IOException;

class MessageTypeAdapter
extends TypeAdapter<Message> {
    static final TypeAdapterFactory MESSAGE_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getRawType() != Message.class) {
                return null;
            }
            TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new MessageTypeAdapter(delegate);
        }
    };
    private final TypeAdapter<Message> delegate;

    private MessageTypeAdapter(TypeAdapter<Message> delegate) {
        this.delegate = delegate;
    }

    public void write(JsonWriter out, Message message) throws IOException {
        out.beginObject();
        out.name("role");
        out.value(message.role().toString());
        out.name("content");
        if (message.content() == null) {
            boolean serializeNulls = out.getSerializeNulls();
            out.setSerializeNulls(true);
            out.nullValue();
            out.setSerializeNulls(serializeNulls);
        } else {
            out.value(message.content());
        }
        if (message.name() != null) {
            out.name("name");
            out.value(message.name());
        }
        if (message.functionCall() != null) {
            out.name("function_call");
            TypeAdapter functionCallTypeAdapter = Json.GSON.getAdapter(FunctionCall.class);
            functionCallTypeAdapter.write(out, (Object)message.functionCall());
        }
        out.endObject();
    }

    public Message read(JsonReader in) throws IOException {
        return (Message)this.delegate.read(in);
    }
}

