/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.ememory.chat.redis;

import dev.langchain4j.community.store.ememory.chat.redis.RedisChatMemoryStoreException;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageDeserializer;
import dev.langchain4j.data.message.ChatMessageSerializer;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.memory.chat.ChatMemoryStore;
import java.util.ArrayList;
import java.util.List;
import redis.clients.jedis.JedisPooled;

public class RedisChatMemoryStore
implements ChatMemoryStore {
    private final JedisPooled client;

    public RedisChatMemoryStore(String host, Integer port, String user, String password) {
        String finalHost = ValidationUtils.ensureNotBlank((String)host, (String)"host");
        int finalPort = (Integer)ValidationUtils.ensureNotNull((Object)port, (String)"port");
        if (user != null) {
            String finalUser = ValidationUtils.ensureNotBlank((String)user, (String)"user");
            String finalPassword = ValidationUtils.ensureNotBlank((String)password, (String)"password");
            this.client = new JedisPooled(finalHost, finalPort, finalUser, finalPassword);
        } else {
            this.client = new JedisPooled(finalHost, finalPort);
        }
    }

    public List<ChatMessage> getMessages(Object memoryId) {
        String json = this.client.get(RedisChatMemoryStore.toMemoryIdString(memoryId));
        return json == null ? new ArrayList() : ChatMessageDeserializer.messagesFromJson((String)json);
    }

    public void updateMessages(Object memoryId, List<ChatMessage> messages) {
        String json = ChatMessageSerializer.messagesToJson((List)((List)ValidationUtils.ensureNotEmpty(messages, (String)"messages")));
        String res = this.client.set(RedisChatMemoryStore.toMemoryIdString(memoryId), json);
        if (!"OK".equals(res)) {
            throw new RedisChatMemoryStoreException("Set memory error, msg=" + res);
        }
    }

    public void deleteMessages(Object memoryId) {
        this.client.del(RedisChatMemoryStore.toMemoryIdString(memoryId));
    }

    private static String toMemoryIdString(Object memoryId) {
        boolean isNullOrEmpty;
        boolean bl = isNullOrEmpty = memoryId == null || memoryId.toString().trim().isEmpty();
        if (isNullOrEmpty) {
            throw new IllegalArgumentException("memoryId cannot be null or empty");
        }
        return memoryId.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String user;
        private String password;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public RedisChatMemoryStore build() {
            return new RedisChatMemoryStore(this.host, this.port, this.user, this.password);
        }
    }
}

