/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.zhipu;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.langchain4j.Internal;
import dev.langchain4j.community.model.zhipu.Json;
import dev.langchain4j.internal.Utils;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.MacAlgorithm;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.util.HashMap;
import javax.crypto.spec.SecretKeySpec;

@Internal
class AuthorizationUtils {
    private static final long expireMillis = 1800000L;
    private static final String id = "HS256";
    private static final String jcaName = "HmacSHA256";
    private static final MacAlgorithm macAlgorithm;
    private static final Cache<String, String> cache;

    private AuthorizationUtils() throws InstantiationException {
        throw new InstantiationException("Can not instantiate utility class");
    }

    public static String getToken(String apiKey) {
        String token = (String)Utils.getOrDefault((Object)((String)cache.getIfPresent((Object)apiKey)), (Object)AuthorizationUtils.generateToken(apiKey));
        return "Bearer " + token;
    }

    private static String generateToken(String apiKey) {
        String[] apiKeyParts = apiKey.split("\\.");
        String keyId = apiKeyParts[0];
        String secret = apiKeyParts[1];
        HashMap<String, Object> payload = new HashMap<String, Object>(3);
        payload.put("api_key", keyId);
        payload.put("exp", System.currentTimeMillis() + 1800000L);
        payload.put("timestamp", System.currentTimeMillis());
        String token = ((JwtBuilder)((JwtBuilder.BuilderHeader)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)"alg", (Object)id)).add((Object)"sign_type", (Object)"SIGN")).and()).content(Json.toJson(payload)).signWith((Key)new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), jcaName), (SecureDigestAlgorithm)macAlgorithm).compact();
        cache.put((Object)apiKey, (Object)token);
        return token;
    }

    static {
        try {
            int minKeyBitLength = 128;
            Class<?> c = Class.forName("io.jsonwebtoken.impl.security.DefaultMacAlgorithm");
            Constructor<?> ctor = c.getDeclaredConstructor(String.class, String.class, Integer.TYPE);
            ctor.setAccessible(true);
            macAlgorithm = (MacAlgorithm)ctor.newInstance(id, jcaName, minKeyBitLength);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        cache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMillis(1800000L)).build();
    }
}

