/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.request;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.request.ResponseFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Experimental
public class ChatRequest {
    private final List<ChatMessage> messages;
    private final List<ToolSpecification> toolSpecifications;
    private final ResponseFormat responseFormat;

    private ChatRequest(Builder builder) {
        this.messages = new ArrayList<ChatMessage>(ValidationUtils.ensureNotEmpty(builder.messages, "messages"));
        this.toolSpecifications = Utils.copyIfNotNull(builder.toolSpecifications);
        this.responseFormat = builder.responseFormat;
    }

    public List<ChatMessage> messages() {
        return this.messages;
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public ResponseFormat responseFormat() {
        return this.responseFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatRequest that = (ChatRequest)o;
        return Objects.equals(this.messages, that.messages) && Objects.equals(this.toolSpecifications, that.toolSpecifications) && Objects.equals(this.responseFormat, that.responseFormat);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.toolSpecifications, this.responseFormat);
    }

    public String toString() {
        return "ChatRequest { messages = " + String.valueOf(this.messages) + ", toolSpecifications = " + String.valueOf(this.toolSpecifications) + ", responseFormat = " + String.valueOf(this.responseFormat) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatMessage> messages;
        private List<ToolSpecification> toolSpecifications;
        private ResponseFormat responseFormat;

        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            return this;
        }

        public Builder messages(ChatMessage ... messages) {
            return this.messages(Arrays.asList(messages));
        }

        public Builder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        public Builder toolSpecifications(ToolSpecification ... toolSpecifications) {
            return this.toolSpecifications(Arrays.asList(toolSpecifications));
        }

        public Builder responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this);
        }
    }
}

