/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.command.JGitFlowCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.extension.ExtensionCommand;
import com.atlassian.jgitflow.core.extension.ExtensionFailStrategy;
import com.atlassian.jgitflow.core.extension.JGitFlowExtension;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import com.atlassian.jgitflow.core.util.RequirementHelper;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGitFlowCommand<C, T>
implements Callable<T>,
JGitFlowCommand {
    private static final Logger log = LoggerFactory.getLogger(AbstractGitFlowCommand.class);
    protected final Git git;
    protected final GitFlowConfiguration gfConfig;
    protected final JGitFlowReporter reporter = JGitFlowReporter.get();
    protected final RequirementHelper requirementHelper;
    private boolean allowUntracked;
    private String scmMessagePrefix;
    private String scmMessageSuffix;
    private boolean fetch;
    private boolean push;
    private final String branchName;

    protected AbstractGitFlowCommand(String branchName, Git git, GitFlowConfiguration gfConfig) {
        Preconditions.checkNotNull(branchName);
        Preconditions.checkNotNull(git);
        Preconditions.checkNotNull(gfConfig);
        this.requirementHelper = new RequirementHelper(git, gfConfig, this.getCommandName());
        this.git = git;
        this.gfConfig = gfConfig;
        this.allowUntracked = false;
        this.scmMessagePrefix = "";
        this.scmMessageSuffix = "";
        this.fetch = false;
        this.push = false;
        this.branchName = branchName;
    }

    protected void doFetchIfNeeded(JGitFlowExtension fetchingExtension) throws GitAPIException, JGitFlowGitAPIException, JGitFlowExtensionException {
        if (this.fetch) {
            this.runExtensionCommands(fetchingExtension.beforeFetch());
            this.git.fetch().setRemote("origin").call();
            this.runExtensionCommands(fetchingExtension.afterFetch());
        }
    }

    protected void doPushIfNeeded(JGitFlowExtension pushExtension, boolean includeTags, String ... branchesToPush) throws GitAPIException, JGitFlowGitAPIException, JGitFlowExtensionException {
        if (this.push) {
            this.reporter.infoText(this.getCommandName(), "pushing changes to origin...");
            for (String branchToPush : branchesToPush) {
                if (!GitHelper.remoteBranchExists(this.git, branchToPush)) continue;
                this.reporter.infoText(this.getCommandName(), "pushing '" + branchToPush + "'");
                RefSpec branchSpec = new RefSpec(branchToPush);
                Iterable i = this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                for (PushResult pr : i) {
                    this.reporter.infoText(this.getCommandName(), "messages: '" + pr.getMessages() + "'");
                    for (RemoteRefUpdate update : pr.getRemoteUpdates()) {
                        RefUpdate.Result trackingResult;
                        if (!update.hasTrackingRefUpdate() || !this.failedResult(trackingResult = update.getTrackingRefUpdate().getResult())) continue;
                        if (pr.getMessages() != null && pr.getMessages().length() > 0) {
                            throw new JGitFlowGitAPIException("error pushing to " + branchToPush + " - status: " + trackingResult.name() + " - " + pr.getMessages());
                        }
                        throw new JGitFlowGitAPIException("error pushing to " + branchToPush + " - " + trackingResult.name());
                    }
                }
            }
            if (includeTags) {
                this.reporter.infoText(this.getCommandName(), "pushing tags");
                this.git.push().setRemote("origin").setPushTags().call();
            }
            this.git.fetch().setRemote("origin").call();
            this.runExtensionCommands(pushExtension.afterPush());
        }
    }

    private boolean failedResult(RefUpdate.Result trackingResult) {
        boolean isFailed = false;
        switch (trackingResult) {
            case LOCK_FAILURE: 
            case REJECTED: 
            case REJECTED_CURRENT_BRANCH: 
            case IO_FAILURE: {
                isFailed = true;
            }
        }
        return isFailed;
    }

    protected String runBeforeAndGetPrefixedBranchName(Iterable<ExtensionCommand> before, JGitFlowConstants.PREFIXES prefix) throws JGitFlowExtensionException {
        this.reporter.commandCall(this.getCommandName());
        this.runExtensionCommands(before);
        return this.gfConfig.getPrefixValue(prefix.configKey()) + this.branchName;
    }

    protected void ensureLocalBranchesNotBehindRemotes(String ... branchesToTest) throws JGitFlowGitAPIException, BranchOutOfDateException, JGitFlowIOException {
        for (String branchToTest : branchesToTest) {
            if (!GitHelper.remoteBranchExists(this.git, branchToTest)) continue;
            this.enforcer().requireLocalBranchNotBehindRemote(branchToTest);
        }
    }

    public C setAllowUntracked(boolean allow) {
        this.allowUntracked = allow;
        return (C)this;
    }

    @Override
    public boolean isAllowUntracked() {
        return this.allowUntracked;
    }

    @Override
    public String getScmMessagePrefix() {
        return this.scmMessagePrefix;
    }

    public C setScmMessagePrefix(String scmMessagePrefix) {
        this.scmMessagePrefix = scmMessagePrefix;
        return (C)this;
    }

    @Override
    public String getScmMessageSuffix() {
        return this.scmMessageSuffix;
    }

    public C setScmMessageSuffix(String scmMessageSuffix) {
        this.scmMessageSuffix = scmMessageSuffix;
        return (C)this;
    }

    public C setFetch(boolean fetch) {
        this.fetch = fetch;
        return (C)this;
    }

    @Override
    public boolean isFetch() {
        return this.fetch;
    }

    public C setPush(boolean push) {
        this.push = push;
        return (C)this;
    }

    @Override
    public boolean isPush() {
        return this.push;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    protected abstract String getCommandName();

    protected void runExtensionCommands(Iterable<ExtensionCommand> commands) throws JGitFlowExtensionException {
        for (ExtensionCommand command : commands) {
            try {
                command.execute(this.gfConfig, this.git, this);
            }
            catch (JGitFlowExtensionException e) {
                if (ExtensionFailStrategy.ERROR.equals((Object)command.failStrategy())) {
                    throw e;
                }
                log.warn("Error running JGitFlow Extension", (Throwable)e);
            }
        }
    }

    protected RequirementHelper enforcer() {
        return this.requirementHelper;
    }
}

