/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core.command;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.command.AbstractBranchMergingCommand;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowExtensionException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.extension.ReleaseFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.EmptyReleaseFinishExtension;
import com.atlassian.jgitflow.core.extension.impl.MergeProcessExtensionWrapper;
import com.atlassian.jgitflow.core.util.Preconditions;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseFinishCommand
extends AbstractBranchMergingCommand<ReleaseFinishCommand, ReleaseMergeResult> {
    private static final Logger log = LoggerFactory.getLogger(ReleaseFinishCommand.class);
    private static final String SHORT_NAME = "release-finish";
    private boolean noTag;
    private boolean squash;
    private boolean noMerge;
    private ReleaseFinishExtension extension;

    public ReleaseFinishCommand(String releaseName, Git git, GitFlowConfiguration gfConfig) {
        super(releaseName, git, gfConfig);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)releaseName));
        this.noTag = false;
        this.squash = false;
        this.noMerge = false;
        this.extension = new EmptyReleaseFinishExtension();
    }

    @Override
    public ReleaseMergeResult call() throws JGitFlowGitAPIException, LocalBranchMissingException, DirtyWorkingTreeException, JGitFlowIOException, BranchOutOfDateException, JGitFlowExtensionException, NotInitializedException {
        String prefixedBranchName = this.runBeforeAndGetPrefixedBranchName(this.extension.before(), JGitFlowConstants.PREFIXES.RELEASE);
        this.enforcer().requireGitFlowInitialized();
        this.enforcer().requireLocalBranchExists(prefixedBranchName);
        this.enforcer().requireCleanWorkingTree(this.isAllowUntracked());
        MergeResult developResult = this.createEmptyMergeResult();
        MergeResult masterResult = this.createEmptyMergeResult();
        try {
            this.doFetchIfNeeded(this.extension);
            this.ensureLocalBranchesNotBehindRemotes(prefixedBranchName, this.gfConfig.getMaster(), this.gfConfig.getDevelop());
            this.checkoutTopicBranch(prefixedBranchName, this.extension);
            boolean mergeSuccess = false;
            if (!this.noMerge) {
                if (log.isDebugEnabled()) {
                    log.debug("merging topic branch to master...");
                }
                MergeProcessExtensionWrapper masterExtension = new MergeProcessExtensionWrapper(this.extension.beforeMasterCheckout(), this.extension.afterMasterCheckout(), this.extension.beforeMasterMerge(), this.extension.afterMasterMerge());
                masterResult = this.doMerge(prefixedBranchName, this.gfConfig.getMaster(), masterExtension, this.squash);
                if (!this.noTag && masterResult.getMergeStatus().isSuccessful()) {
                    this.doTag(this.gfConfig.getMaster(), this.getMessage(), masterResult, this.extension);
                }
                MergeProcessExtensionWrapper developExtension = new MergeProcessExtensionWrapper(this.extension.beforeDevelopCheckout(), this.extension.afterDevelopCheckout(), this.extension.beforeDevelopMerge(), this.extension.afterDevelopMerge());
                if (log.isDebugEnabled()) {
                    log.debug("back merging master to develop...");
                }
                if (mergeSuccess = this.checkMergeResults(masterResult, developResult = this.doMerge(this.gfConfig.getMaster(), this.gfConfig.getDevelop(), developExtension, this.squash))) {
                    this.doPushIfNeeded(this.extension, !this.noTag, this.gfConfig.getDevelop(), this.gfConfig.getMaster(), prefixedBranchName);
                }
            }
            if (this.noMerge || mergeSuccess) {
                this.cleanupBranchesIfNeeded(this.gfConfig.getDevelop(), prefixedBranchName);
            }
            if (log.isDebugEnabled()) {
                log.debug("checking out develop...");
            }
            this.reporter.infoText(this.getCommandName(), "checking out '" + this.gfConfig.getDevelop() + "'");
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
            this.runExtensionCommands(this.extension.after());
            ReleaseMergeResult releaseMergeResult = new ReleaseMergeResult(masterResult, developResult);
            return releaseMergeResult;
        }
        catch (GitAPIException e) {
            this.reporter.errorText(this.getCommandName(), e.getMessage());
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            this.reporter.endCommand();
            this.reporter.flush();
        }
    }

    public ReleaseFinishCommand setNoTag(boolean noTag) {
        this.noTag = noTag;
        return this;
    }

    public ReleaseFinishCommand setSquash(boolean squash) {
        this.squash = squash;
        return this;
    }

    public ReleaseFinishCommand setNoMerge(boolean noMerge) {
        this.noMerge = noMerge;
        return this;
    }

    public ReleaseFinishCommand setExtension(ReleaseFinishExtension extension) {
        this.extension = extension;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

