package com.zbank.file.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zbank.file.bean.FileInfo;
import com.zbank.file.bean.FileQueryRequest;
import com.zbank.file.bean.FileQueryResponse;
import com.zbank.file.bean.FileSyncDownloadRequest;
import com.zbank.file.bean.FileSyncDownloadResponse;
import com.zbank.file.bean.ImageDownloadRequest;
import com.zbank.file.bean.ImageDownloadResponse;
import com.zbank.file.bean.PreUploadRequest;
import com.zbank.file.bean.PreUploadResponse;
import com.zbank.file.bean.SplitDownLoadRequest;
import com.zbank.file.bean.SplitDownLoadResponse;
import com.zbank.file.bean.StreamDownLoadInfo;
import com.zbank.file.bean.UploadLimitConfig;
import com.zbank.file.bean.UploadRequest;
import com.zbank.file.bean.UploadResponse;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.exception.SDKException;
import com.zbank.file.secure.IPackSecure;

public interface APIService {
    /**
     * 请求头参数key
     */
    String PARAM_HEADER = "HeaderRequest";
    /**
     * 加密模式
     */
    String ENCRYPT_TYPE_HEADER = "encryptType";
    
    /**
     * 加密密钥
     */
    String ENCRYPT_KEY = "encryptKey";
    
    /**
     * 校验和
     */
    String CKS_STR="cksStr";
    
    /**
     * SM2的向量
     */
    String IV="iv";
    /**
     * 文件预上传接口
     *
     * @param request
     * @param packSecure 对报文进行加解密的接口实现，如有必要加密则传值，否则直接传空
     * @return
     * @throws SDKException
     * @config http请求配置。如果不需要配置，直接传空
     */
    public PreUploadResponse preUpload(PreUploadRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;


    /**
     * 文件上传接口
     *
     * @param request
     * @param packSecure 对报文进行加解密的接口实现，如有必要加密则传值，否则直接传空
     * @return
     * @throws SDKException
     * @config http请求配置。如果不需要配置，直接传空
     */
    public UploadResponse splitUpload(UploadRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;

    /**
     * 文件查询接口
     *
     * @param request
     * @param packSecure 对报文进行加解密的接口实现，如有必要加密则传值，否则直接传空
     * @return
     * @throws SDKException
     * @config http请求配置。如果不需要配置，直接传空
     */
    public FileQueryResponse fileQuery(FileQueryRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;


    /**
     * 文件分片下载
     *
     * @param request
     * @param packSecure 对报文进行加解密的接口实现，如有必要加密则传值，否则直接传空
     * @return
     * @throws SDKException
     * @config http请求配置。如果不需要配置，直接传空
     */
    public SplitDownLoadResponse splitDownLoad(SplitDownLoadRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;


    /**
     * 文件同步流下载，即,返回java.io.InputStream
     *
     * @param request
     * @param packSecure 对报文进行加解密的接口实现，如有必要加密则传值，否则直接传空
     * @return
     * @throws SDKException
     * @config http请求配置。如果不需要配置，直接传空
     */
    public FileSyncDownloadResponse fileSyncDownLoad(FileSyncDownloadRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;

    /**
     * 从影像平台下载文件
     *
     * @param request
     * @param config
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public ImageDownloadResponse downloadFromImageSystem(ImageDownloadRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;
    
    /**
     * 查询文件列表
     * @return
     * @throws SDKException
     */
    public List<FileInfo> queryFileList(FileQueryRequest request, HttpConfig config, IPackSecure packSecure) throws SDKException;

    /**
     * 文件分片上传至影像平台，完成通知接口
     * @return
     * @throws SDKException
     */
    public Map<String, Object> upload2009Notice(HashMap<String, Object> maphead, byte[] fileBytes, HttpConfig config, IPackSecure packSecure) throws SDKException;
   
    
    /**
     * 查询文件上传完成结果接口
     * @return
     * @throws SDKException
     */
    public Map<String, Object> query2109Rst(HashMap<String, Object> maphead, HttpConfig config, IPackSecure packSecure) throws SDKException;
    
    /**
     * 根据渠道查询文件上传大小限制
     * 
     * @param channelId
     * @param config
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public UploadLimitConfig queryFileUploadLimitConfig(String channelId, HttpConfig config, IPackSecure packSecure) throws SDKException;
    
    
    /**
     * 影像平台进行大文件下载
     * @param request
     * @param config
     * @param packSecure
     * @return
     */
    public StreamDownLoadInfo downloadBigImage(HashMap<String, Object> maphead, HttpConfig config, IPackSecure packSecure) throws SDKException;
    
    /**
     * 加密函数，用于将明文进行加密，并放入httpRequsetHeander
     *
     * @param obj
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public Map<String, String> convertToHeader(Object obj, IPackSecure packSecure) throws SDKException ;
    
    /**
     * 该接口用于将文件体进行加密
     * @param fileBytes
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public byte[] encryptFileBytes(byte[] fileBytes,IPackSecure packSecure) throws SDKException ;
    
    /**
     * 该接口用于将加密的文件体进行解密
     * @param fileBytes
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public byte[] decryptFileBytes(byte[] fileBytes,IPackSecure packSecure)throws SDKException ;
    
    /**
     * 调用影像平台2001接口，完成小文件上传
     * @param maphead 报文头
     * @param fileBytes 文件内容
     * @param config
     * @param packSecure
     * @return
     * @throws SDKException
     */
    public Map<String, Object>  upload2001(HashMap<String, Object> maphead, byte[] fileBytes, HttpConfig config, IPackSecure packSecure) throws SDKException;
}
