package com.zbank.file.api;

/**
 * @author daiwj
 * @date 2021/04/26
 * @description:
 */
public enum ServiceEnum {

    /**
     * 预上传
     */
    PRE_FILE_UPLOAD("PreUpload", "/storage_tracker/serv/PreUploadSer"),
    /**
     * 分片上传
     */
    FILE_UPLOAD("FileUpload", "/storage_tracker/serv/UploadSer"),
    /**
     * 文件查询
     */
    FILE_INFO_QUERY("FileInfoQuery", "/storage_tracker/serv/QueryFileInfo"),
    /**
     * 分片文件下载
     */
    SPLIT_FILE_DOWNLOAD("SplitFileDownload", "/storage_tracker/serv/DownLoadFile"),
    /**
     * 文件下载
     */
    FILE_DOWNLOAD("FileDownload", "/storage_tracker/serv/downLoadStream"),
    
    /**
     * 文件批量查询
     */
    QUERY_FILE_BATCH("queryFileBatch", "/storage_tracker/serv/queryFileBatch"),

    /**
     * 文件上传完成通知接口
     */
    FILE_2009_NOTICE("File2009", "/storage_tracker/imageSquare/File2009"),
    
    /**
     * 查询大文件影像上传结果
     */
    FILE_2109_RESULT("File2109", "/storage_tracker/imageSquare/File2109"),
    
    /**
     * 查询渠道文件上传大小限制参数
     */
    FILE_UPLOAD_CONFIG("UploadConfig", "/storage_tracker/imageSquare/UploadConfig"),

    /**
     * 影像平台文件下载，实际上调用的是影像平台2002、L2005接口
     */
    IMG_SYSTEM_FILE_DOWNLOAD("ImageSystemFileDownload", "/storage_tracker/serv/downloadFromImageSystem"),
	
	/**
     * 影像平台大文件下载，实际上调用的是影像平台大文件下载接口
     */
    IMG_BIG_FILE_DOWNLOAD("ImageBigFileDownload", "/storage_tracker/imageSquare/BigFileDownload"),
	
	/**
     * 影像品台2001文件上传接口调用
     */
    IMG_BIG_FILE_UPLOAD_2001("File2001", "/storage_tracker/imageSquare/File2001");

    private String serviceId;
    private String uri;

    ServiceEnum(String serviceId, String uri) {
        this.serviceId = serviceId;
        this.uri = uri;
    }

    public String getServiceId() {
        return serviceId;
    }

    public String getUri() {
        return uri;
    }

}
