package com.zbank.file.bean;

import java.util.Map;

/**
 * @author daiwj
 * @date 2021/04/25
 * @description: 加解密参数配置
 */
public class SecureConfig {
    /**
     * 己方私钥字符串
     */
    private String priKey;
    /**
     * 服务方公钥字符串
     */
    private String serverPubKey;
    /**
     * 额外的参数map
     */
    private Map<String, Object> extMap;
    
    public SecureConfig(String priKey, String serverPubKey) {
        this.priKey = priKey;
        this.serverPubKey = serverPubKey;
    }

    public SecureConfig(String priKey, String serverPubKey, Map<String, Object> extMap) {
        this.priKey = priKey;
        this.serverPubKey = serverPubKey;
        this.extMap = extMap;
    }

    public String getPriKey() {
        return priKey;
    }

    public SecureConfig setPriKey(String priKey) {
        this.priKey = priKey;
        return this;
    }

    public String getServerPubKey() {

        return serverPubKey;
    }

    public SecureConfig setServerPubKey(String serverPubKey) {
        this.serverPubKey = serverPubKey;
        return this;
    }

    public Map<String, Object> getExtMap() {
        return extMap;
    }

    public SecureConfig setExtMap(Map<String, Object> extMap) {
        this.extMap = extMap;
        return this;
    }
}
