package com.zbank.file.bean;

import java.io.InputStream;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;

import com.zbank.file.exception.SDKException;

public class StreamDownLoadInfo extends DownLoadInfo{

	private CloseableHttpResponse resp;
	private CloseableHttpClient client;
	
	private InputStream inputStream;
	
	public void setInputStream(InputStream inputStream) {
		this.inputStream = inputStream;
	}
	
	public void setResp(CloseableHttpResponse resp) {
		this.resp = resp;
	}
	

	public void setClient(CloseableHttpClient client) {
		this.client = client;
	}

	/**
	 * 已过时。读取数据时，可直接通过<code>StreamDownLoadInfo.read(byte[] buffer)</code>方法读取.没必要获取InputStream后再读取。
	 * @return
	 * @throws SDKException
	 */
	@Deprecated
	public InputStream getInputStream() throws SDKException {
		try {
			if (inputStream != null) {
				return inputStream;
			}
			if (resp != null) {
				return resp.getEntity().getContent();
			}
		} catch (Exception e) {
			throw new SDKException("获取数据流失败", e);
		}
		throw new SDKException("获取数据流失败,返回的response为空!!");
	}
	
	/**
	 * 从流中读取数据到buffer数组中
	 * @param buffer
	 * @return 读取的字节数
	 * @throws SDKException
	 */
	public int read(byte[] buffer) throws SDKException{
		try{
			InputStream in = getInputStream();
			return in.read(buffer);
		}catch(Exception e){
			if(e instanceof SDKException){
				throw (SDKException)e;
			}
			throw new SDKException("读取数据失败",e);
		}
		
	}
	
	/**
	 * 读取去len个字节到buffer数组中，写数组的初始偏移量为off
	 * 
	 * @param buffer 数组缓冲区
	 * @param off    写数组的初始偏移量
	 * @param len    读取的数据长度
	 * @return 读取的字节数
	 * @throws SDKException
	 */
	public int read(byte[] buffer, int off, int len) throws SDKException{
		try{
			InputStream in = getInputStream();
			return in.read(buffer,off,len);
		}catch(Exception e){
			if(e instanceof SDKException){
				throw (SDKException)e;
			}
			throw new SDKException("读取数据失败",e);
		}
	}

	/**
	 * 释放CloseableHttpResponse、CloseableHttpClient、inputStream等资源!!
	 */
	public void releaseResouces() {
		HttpClientUtils.closeQuietly(resp);
		HttpClientUtils.closeQuietly(client);
		try {
			if (inputStream != null) {
				inputStream.close();
			}
		} catch (Exception e) {

		}
	}
	
	
}
