package com.zbank.file.common.http.bean;

import java.util.Map;

import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;

public class BinaryDataResponse {

	private String code;
	private String message;
	private byte[] binaryData;
	private Map<String,Object> resultMap;
	private CloseableHttpResponse resp;
	private CloseableHttpClient client;

	public BinaryDataResponse(String code, String message, byte[] binaryData, Map<String,Object> resultMap) {
		this.code = code;
		this.message = message;
		this.binaryData = binaryData;
		this.resultMap = resultMap;
	}

	public BinaryDataResponse(String code, String message, CloseableHttpResponse resp,CloseableHttpClient client, Map<String,Object> resultMap) {
		this.code = code;
		this.message = message;
		this.resp = resp;
		this.resultMap = resultMap;
		this.client = client;
	}

	public String getCode() {
		return code;
	}

	public String getMessage() {
		return message;
	}

	public byte[] getBinaryData() {
		return binaryData;
	}
	
	
	public Map<String, Object> getResult() {
		return resultMap;
	}
	
	public void setResult(Map<String, Object> resultMap) {
		this.resultMap = resultMap;
	}

	public CloseableHttpResponse getResp() {
		return resp;
	}

	public CloseableHttpClient getClient() {
		return client;
	}
	
	
}
