package com.zbank.file.common.http.config;

public class HttpConfig {

	
	/**
	 * 每个路由最大连接数
	 */
	private int maxConnPerRoute = -1;
	/**
	 * 最大连接数
	 */
	private int maxConnTotal = -1;
	/**
	 * 从连接池获取连接超时时间，毫秒
	 */
	private int connRequestTimeout = 10000;

	/**
	 * 与服务端建立连接超时时间，毫秒
	 */
	private int connTimeout = 10000;
	/**
	 * 读取服务端响应超时时间，毫秒
	 */
	private int socketTimeout = 30000;

	/**
	 * http代理服务器地址
	 */
	private String proxyHost;
	
	/**
	 * http代理服务器端口
	 */
	private int proxyPort = -1;
	
	/**
	 *是否为ss5代理
	 */
	private boolean isSockts;
	/**
	 * ss5代理ip
	 */
	private String socktsIp;

	/**
	 * ss5代理端口
	 */
	private int socktsPort ;
	
	/**
	 * ss5代理协议类型。值可以为https或者http
	 */
	private Protocal protocal;
	
	public static HttpConfig defaultConfig = new HttpConfig();
	

	public int getConnRequestTimeout() {
		return connRequestTimeout;
	}

	public HttpConfig setConnRequestTimeout(int connRequestTimeout) {
		this.connRequestTimeout = connRequestTimeout;
		return this;
	}

	public int getConnTimeout() {
		return connTimeout;
	}

	public HttpConfig setConnTimeout(int connTimeout) {
		this.connTimeout = connTimeout;
		return this;
	}

	public int getSocketTimeout() {
		return socketTimeout;
	}

	public HttpConfig setSocketTimeout(int socketTimeout) {
		this.socketTimeout = socketTimeout;
		return this;
	}

	public String getProxyHost() {
		return proxyHost;
	}

	public HttpConfig setProxyHost(String proxyHost) {
		this.proxyHost = proxyHost;
		return this;
	}

	public int getMaxConnPerRoute() {
		return maxConnPerRoute;
	}

	public HttpConfig setMaxConnPerRoute(int maxConnPerRoute) {
		this.maxConnPerRoute = maxConnPerRoute;
		return this;
	}

	public int getMaxConnTotal() {
		return maxConnTotal;
	}

	public HttpConfig setMaxConnTotal(int maxConnTotal) {
		this.maxConnTotal = maxConnTotal;
		return this;
	}

	
	public int getProxyPort() {
		return proxyPort;
	}

	
	public HttpConfig setProxyPort(int proxyPort) {
		this.proxyPort = proxyPort;
		return this;
	}

	
	public boolean isSockts() {
		return isSockts;
	}

	
	public HttpConfig setSockts(boolean isSockts) {
		this.isSockts = isSockts;
		return this;
	}
	public String getSocktsIp() {
		return socktsIp;
	}

	
	public HttpConfig setSocktsIp(String socktsIp) {
		this.socktsIp = socktsIp;
		return this;
	}

	
	public int getSocktsPort() {
		return socktsPort;
	}

	
	public HttpConfig setSocktsPort(int socktsPort) {
		this.socktsPort = socktsPort;
		return this;
	}

	
	public Protocal getProtocal() {
		return protocal;
	}

	
	public HttpConfig setProtocal(Protocal protocal) {
		this.protocal = protocal;
		return this;
	}


	
}
