package com.zbank.file.common.http.ss5;


import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

import com.zbank.file.common.http.config.HttpConfig;

/**
 * http 或 https客户端工厂类
 * 
 * @author 201511020388
 *
 */
public class HttpClientFactory {

	/**
	 * 工厂对象
	 */
	private static HttpClientFactory factory = null;

	/**
	 * http client单例对象
	 */
	private CloseableHttpClient client = null;

	/**
	 * 默认的协议
	 */
	private static final String DEFAULT_PROCOTOL_HTTP = "http";

	/**
	 * https协议
	 */
	private static final String PROCOTOL_HTTPS = "https";


	private HttpClientFactory() {
	}

	public static HttpClientFactory getInstance() {
		if (factory == null) {
			factory = new HttpClientFactory();
		}
		return factory;
	}

	public CloseableHttpClient getHttpClient(HttpConfig config) throws Exception {
		if (this.client == null) {

			Registry<ConnectionSocketFactory> r = RegistryBuilder.<ConnectionSocketFactory> create()
					.register(DEFAULT_PROCOTOL_HTTP, new Socks5ConnectionSocket(config)).register(PROCOTOL_HTTPS,
							new NsSSLConnectionSocketFactory(SSLContextTLSFactory.getInstance().getSSLContext(), config))
					.build();
			PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(r);
			if (config.getMaxConnPerRoute() != -1) {
				cm.setDefaultMaxPerRoute(config.getMaxConnPerRoute());
			}
			if (config.getMaxConnTotal() != -1) {
				cm.setMaxTotal(config.getMaxConnTotal());
			}
			RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(config.getConnTimeout())
					.setSocketTimeout(config.getSocketTimeout()).build();
			this.client = HttpClients.custom().setConnectionManager(cm).setDefaultRequestConfig(requestConfig).build();
		}
		return this.client;
	}

}
