package com.zbank.file.common.http.ss5;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;

import javax.net.ssl.SSLContext;

import org.apache.http.HttpHost;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

import com.zbank.file.common.http.config.HttpConfig;



/**
 * https socket5 代理实现类
 * 
 * @author 201511020388
 *
 */
public class NsSSLConnectionSocketFactory extends SSLConnectionSocketFactory {

	private HttpConfig conf;

	@SuppressWarnings("deprecation")
	public NsSSLConnectionSocketFactory(final SSLContext sslContext, HttpConfig conf) {
		super(sslContext, ALLOW_ALL_HOSTNAME_VERIFIER);
		this.conf = conf;
	}

	@Override
	public Socket createSocket(HttpContext context) throws IOException {
		InetSocketAddress socksaddr = new InetSocketAddress(conf.getSocktsIp(), conf.getSocktsPort());
		Proxy proxy = new Proxy(Proxy.Type.SOCKS, socksaddr);
		Socket socket = new Socket(proxy);
		socket.setKeepAlive(true);
		return socket;
	}

	@Override
	public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress,
			InetSocketAddress localAddress, HttpContext context) throws IOException {
		InetSocketAddress unresolvedRemote = InetSocketAddress.createUnresolved(host.getHostName(), remoteAddress.getPort());
		return super.connectSocket(connectTimeout, socket, host, unresolvedRemote, localAddress, context);
	}

}
