package com.zbank.file.common.http.ss5;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;

import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

import com.zbank.file.common.http.config.HttpConfig;


/**
 * http socket5代理
 * 
 * @author 201511020388
 *
 */
public class Socks5ConnectionSocket implements ConnectionSocketFactory {
	
	

	private HttpConfig conf;
	
	public Socks5ConnectionSocket(HttpConfig conf) {
		this.conf = conf;
	}

	@Override
	public Socket createSocket(HttpContext context) throws IOException {
		Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(conf.getSocktsIp(), conf.getSocktsPort()));
		return new Socket(proxy);
	}

	@Override
	public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress,
			InetSocketAddress localAddress, HttpContext context) throws IOException {

		Socket sock = null;
		if (socket != null) {
			sock = socket;
		} else {
			sock = createSocket(context);
		}
		if (localAddress != null) {
			sock.bind(localAddress);
		}
		try {
			if (sock == null) {
				throw new SocketException("sock is null");
			}
			sock.connect(remoteAddress, connectTimeout);
		} catch (SocketTimeoutException ex) {
			throw new ConnectTimeoutException(ex, host, remoteAddress.getAddress());
		}
		return sock;
	}
}
