package com.zbank.file.common.utils;


import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;

public class AESCBCUtils {

	public static final String KEY_ALGORITHM = "AES";
	// 加密模式为ECB，填充模式为NoPadding
	public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5PADDING";
	// 字符集
	public static final String ENCODING = "UTF-8";
	// 向量
	public static final String IV_SEED = "zb@#nk12iue78bvt";

	/**
	 * AES加密算法
	 * 
	 * @param str
	 * @param key
	 * @return
	 */
	public static String encrypt(String str, String key) throws Exception{
		try {
			if (key == null) {
				throw new RuntimeException("参数key不能为空!!");
			}
			// 判断Key是否为16位
			if (key.length() != 16) {
				throw new RuntimeException("参数key必须为16位!!");
			}
			byte[] raw = key.getBytes(ENCODING);
			SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(IV_SEED.getBytes(ENCODING));
			cipher.init(Cipher.ENCRYPT_MODE, skeySpec, iv);
			byte[] srawt = str.getBytes(ENCODING);
			int len = srawt.length;
			/* 计算补空格后的长度 */
			while (len % 16 != 0)
				len++;
			byte[] sraw = new byte[len];
			/* 在最后空格 */
			for (int i = 0; i < len; ++i) {
				if (i < srawt.length) {
					sraw[i] = srawt[i];
				} else {
					sraw[i] = 32;
				}
			}
			byte[] encrypted = cipher.doFinal(srawt);
			return formatString(new String(Base64.encodeBase64(encrypted), "UTF-8"));
		} catch (Exception ex) {
			throw ex;
		}
	}

	/**
	 * AES解密算法
	 * 
	 * @param str
	 * @param key
	 * @return
	 */
	public static String decrypt(String str, String key) throws Exception{
		try {
			if (key == null) {
				throw new RuntimeException("参数key不能为空!!");
			}
			// 判断Key是否为16位
			if (key.length() != 16) {
				throw new RuntimeException("参数key必须为16位!!");
			}
			byte[] raw = key.getBytes(ENCODING);
			SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
			Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
			IvParameterSpec iv = new IvParameterSpec(IV_SEED.getBytes(ENCODING));
			cipher.init(Cipher.DECRYPT_MODE, skeySpec, iv);
			byte[] bytes = Base64.decodeBase64(str.getBytes("UTF-8"));
			bytes = cipher.doFinal(bytes);
			return new String(bytes, ENCODING);
		} catch (Exception ex) {
			throw ex;
		}
	}

	private static String formatString(String sourceStr) {
		if (sourceStr == null) {
			return null;
		}
		return sourceStr.replaceAll("\\r", "").replaceAll("\\n", "");
	}
	
	/** 
	 * byte数组转化为16进制字符串 
	 * @param bytes 
	 * @return 
	 */  
	public static String byteToHexString(byte[] bytes){       
	    StringBuffer sb = new StringBuffer();       
	    for (int i = 0; i < bytes.length; i++) {       
	         String strHex=Integer.toHexString(bytes[i]);   
	         if(strHex.length() > 3){       
	                sb.append(strHex.substring(6));       
	         } else {    
	              if(strHex.length() < 2){    
	                 sb.append("0" + strHex);    
	              } else {    
	                 sb.append(strHex);       
	              }       
	         }    
	    }    
	   return  sb.toString();       
	}
	

	/** 
     * 随机生成秘钥 
     */  
    public static String getAesKey(){    
        try {    
            KeyGenerator kg = KeyGenerator.getInstance("AES");    
            kg.init(128);//要生成多少位，只需要修改这里即可128, 192或256    
            SecretKey sk = kg.generateKey();    
//            byte[] b = sk.getEncoded();    
            
            byte[] b={1,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8};
            String str = byteToHexString(b);    
            try {
				System.out.println(new String(Base64.encodeBase64(b), "UTF-8"));
			} catch (UnsupportedEncodingException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
            return str;
        } catch (NoSuchAlgorithmException e) {    
            return "defaultaes";
        }    
    } 
    
  

}
