package com.zbank.file.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/**
 * @author daiwj
 * @date 2021/04/26
 * @description:
 */
public class BeanUtils {
    /**
     * 通过对象的get方法获取属性值
     * @param obj
     * @return
     */
    public static Map<String, Object> beanToMap(Object obj) {
        Method[] methods = obj.getClass().getMethods();
        Map<String, Object> map = new HashMap<String, Object>();
        for (Method method : methods) {
            if(method.getParameterTypes().length == 0){
                String name = method.getName();
                if(name.startsWith("get")  && !name.equals("getClass")){
                    char[] keyChars = name.substring(3).toCharArray();
                    keyChars[0] = Character.toLowerCase(keyChars[0]);
                    String key = new String(keyChars);
                    try {
                        Object value = method.invoke(obj);
                        if(value != null){
                            map.put(key, value);
                        }
                    } catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return map;
    }

    /**
     * 通过对象的属性获取属性值
     * @param obj
     * @return
     */
    public static Map<String, Object> beanToMapFromField(Object obj) {
        try {
            Map<String, Object> map = new HashMap<String, Object>();
            Field[] fields = obj.getClass().getFields();
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = field.get(obj);
                if (value != null)
                    map.put(field.getName(), value);
            }
            return map;
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}
