package com.zbank.file.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author daiwj
 * @date 2021/05/06
 * @description:
 */
public class JsonUtil {
    public static ObjectMapper MAPPER = new ObjectMapper();
    static {
        //序列化时只包含不为空的字段
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        //反序列化时 忽略未知属性或在java对象中不存在的属性
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

        MAPPER.disableDefaultTyping();
    }
    public static ObjectMapper getMapper(){
        return MAPPER;
    }
}
