package com.zbank.file.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.codec.digest.DigestUtils;

import com.zbank.file.exception.SDKException;

public class Md5EncodeUtil {
	
	public static String encode(File file) throws SDKException {
		InputStream in = null;
		try {
			in = new FileInputStream(file);
			return DigestUtils.md5Hex(in);
		} catch (Exception e) {
			throw new SDKException(e.getMessage(), e.getCause());
		}finally {
			if (in != null){
				try {
					in.close();
				} catch (IOException e) {}
			}
		}
	}

	public static String encode(InputStream inputStream) throws SDKException {
		try {
			return DigestUtils.md5Hex(inputStream);
		} catch (Exception e) {
			throw new SDKException(e.getMessage(), e.getCause());
		}
	}

	public static String encode(byte[] bytes) throws SDKException{
		try {
			return DigestUtils.md5Hex(bytes);
		} catch (Exception e) {
			throw new SDKException(e.getMessage(), e.getCause());
		}
	}

}
