package com.zbank.file.common.utils;

import java.security.SecureRandom;
import java.util.UUID;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class SM2AESUtils {
	
	/**
	 * 密钥算法
	 */
	public static final String KEY_ALGORITHM = "AES";

	/**
	 * 加密/解密算法 / 工作模式 / 填充方式 Java 6支持PKCS5Padding填充方式 Bouncy
	 * Castle支持PKCS7Padding填充方式
	 */
	public static final String CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";

	/**
	 * 转换密钥
	 * 
	 * @param key
	 *            二进制密钥
	 * @return Key 密钥
	 * @throws Exception
	 */
	private static SecretKey toKey(byte[] key) throws Exception {
		// 实例化AES密钥材料
		SecretKey secretKey = new SecretKeySpec(key, KEY_ALGORITHM);
		return secretKey;
	}
	

	/**
	 * 解密
	 * 
	 * @param data
	 *            待解密数据
	 * @param key
	 *            密钥
	 * @return byte[] 解密数据
	 * @throws Exception
	 */
	public static byte[] decrypt(byte[] data, SecretKey secretKey) throws Exception {
		// 还原密钥
		// Key k = toKey(key);
		/*
		 * 实例化 使用PKCS7Padding填充方式，按如下方式实现 Cipher.getInstance(CIPHER_ALGORITHM,
		 * "BC");
		 */
		Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
		cipher.init(Cipher.DECRYPT_MODE, secretKey);
		return cipher.doFinal(data);
	}

	/**
	 * 加密
	 * 
	 * @param data
	 *            待加密数据
	 * @param key
	 *            密钥
	 * @return byte[] 加密数据
	 * @throws Exception
	 */
	public static byte[] encrypt(byte[] data, SecretKey secretKey) throws Exception {
		// 还原密钥
		// Key k = toKey(key);
		/*
		 * 实例化 使用PKCS7Padding填充方式，按如下方式实现 Cipher.getInstance(CIPHER_ALGORITHM,
		 * "BC");
		 */
		Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
		// 初始化，设置为加密模式
		cipher.init(Cipher.ENCRYPT_MODE, secretKey);
		// 执行操作
		return cipher.doFinal(data);
	}

	/**
	 * 生成密钥 <br>
	 * 
	 * @return byte[] 二进制密钥
	 * @throws Exception
	 */
	public static SecretKey initKey() throws Exception {
		// 实例化
		KeyGenerator kg = KeyGenerator.getInstance(KEY_ALGORITHM);
		/*
		 * AES 要求密钥长度为 128位、192位或 256位
		 */
		kg.init(128,new SecureRandom(UUID.randomUUID().toString().getBytes()));
		// 生成秘密密钥
		SecretKey secretKey = kg.generateKey();
		// 获得密钥的二进制编码形式
		return secretKey;
	}

	public static String wrap(SecretKey secretKey,String sm2PubKey) throws Exception {
		// 对加密密钥进行包装，包装之后就可以进行传输
		byte[] bytes = secretKey.getEncoded();
		return SM2Util.encrypt(Hex.encodeHexString(bytes), sm2PubKey);
	}

	public static SecretKey unwrap(String keyString, String sm2PriKey) throws Exception {
		byte[] bytes = Hex.decodeHex(SM2Util.decrypt(keyString, sm2PriKey).toCharArray());
		return toKey(bytes);
	}
	
	public static void main(String... args) throws Exception {

		String inputStr = "{\"legalCertificateNum\": \"620103197劳动防护卡萨丁哈收到了开关机阿萨德理解哈水电费单号asdjkfhaskdfjgaskdjfgaskldfgasldkjfgasldkfgasdflgweiutrw efr gsdfagdfl askg dljgdljgdlfjkgdjlfagdfjaf003010013\",\"corpName\": \"众邦 银行\",\"legalName\": \"众邦\"}";
		byte[] inputData = inputStr.getBytes("UTF-8");
		System.err.println("原文:\t" + inputStr);

		
		// 初始化密钥
		SecretKey key = SM2AESUtils.initKey();
		String sectPack = Base64.encodeBase64String(SM2AESUtils.encrypt(inputData, key));
		System.out.println("加密后报文:\t" + sectPack);

		// 包装后得密钥
		String kyeString = SM2AESUtils.wrap(key,"0463455a993b27010c80ceaca36f8faddcc5bb942b242faad8196ccda08d9ba556a669d6682d62d5278dbdc7a65d87ea8071635825725c35b92607eb379b369949");
		System.out.println("---------报文传输过程------" + kyeString);

		// 获得密钥
		SecretKey key2 = SM2AESUtils.unwrap(kyeString,"10370a9200c0c426b1cae388455d59c15b2413a316c855b4ff95d1d57f78f468");
		// 解密
		byte[] outputData = SM2AESUtils.decrypt(Base64.decodeBase64(sectPack), key2);

		String outputStr = new String(outputData);
		System.err.println("解密后:\t" + outputStr);

	}
}
