package com.zbank.file.common.utils;

import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.util.encoders.Hex;

import java.security.SecureRandom;

/**
 * @author daiwj
 * @date 2021/05/13
 * @description: SM2密钥对生成方式
 */
public class SM2KeyGenUtil {
    public static final String SPEC_NAME = "sm2p256v1";
    private static final X9ECParameters x9ECParameters = GMNamedCurves.getByName(SPEC_NAME);
    private static final ECDomainParameters ecDomainParameters = new ECDomainParameters(
            x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN());

    public static void main(String[] args) {
        AsymmetricCipherKeyPair keyPair = generateKeyPair();
        // 私钥
        String privateKey = ((ECPrivateKeyParameters) keyPair.getPrivate()).getD().toString(16);
        // 公钥
        String publicKey = Hex.toHexString(((ECPublicKeyParameters) keyPair.getPublic()).getQ().getEncoded(false));

        System.out.println("私钥:\n" + privateKey);
        System.out.println("公钥:\n" + publicKey);
    }

    /**
     * 生成 SM2 公私钥对
     *
     * @return KeyPair
     */
    public static AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator kpGen = new ECKeyPairGenerator();
        kpGen.init(new ECKeyGenerationParameters(ecDomainParameters, new SecureRandom()));
        return kpGen.generateKeyPair();
    }
}
