package com.zbank.file.demo;

import java.io.File;
import java.io.FileOutputStream;
import java.util.UUID;

import com.zbank.file.bean.StreamDownLoadInfo;
import com.zbank.file.common.http.config.HttpConfig;
import com.zbank.file.common.utils.Md5EncodeUtil;
import com.zbank.file.sdk.FileSDK;
import com.zbank.file.sdk.IFileSDK;
import com.zbank.file.secure.SM2SM4PackSecure;

public class FileSDKDemo {

	private static final String url = "http://localhost:8088";
	/**
	 * 渠道唯一标识（由众邦银行提供）
	 */
	private static final String channelId = "12301";
	/**
	 * /** 用于加密的密钥（由众邦银行提供），行外渠道加密使用
	 */
	private static final String encryptKey = "0463455a993b27010c80ceaca36f8faddcc5bb942b242faad8196ccda08d9ba556a669d6682d62d5278dbdc7a65d87ea8071635825725c35b92607eb379b369949";
	/**
	 * 用于加密的校验和字符串（由众邦银行提供），行外渠道加密使用
	 */
	private static final String cksStr = "UQYWEIOQWYEIQWIUEIQYWEYIHDIASD";

	private static IFileSDK sdk;

	static {
		// 1、初始化配置服务方接口url。
		sdk = FileSDK.build(url);
		// 2、配置httpClient相关参数：连接超时时间、响应超时时间、http代理、SS5代理等。详见HttpConfig类
		HttpConfig config = new HttpConfig();
		config.setSocketTimeout(120000);
		sdk.config(config);
		// 3、 配置加解密参数
		sdk.config(new SM2SM4PackSecure(encryptKey, cksStr));
	}

	public static void main(String[] args) throws Exception {
		// 接口请求唯一流水号 需要保证每笔请求流水号唯一，便于交易日志定位
		final String seqNo = UUID.randomUUID().toString();
		// 使用SDK成功上传后返回的fileId 或者是使用之前的SDK上传到影像平台返回的fileId或url
		final String fileId = "C29F42585099497B8E041C7DC3A2756B_12301852";
		StreamDownLoadInfo downLoadInfo = null;
		FileOutputStream fou = null;
		try {
			downLoadInfo = sdk.downloadStream(fileId, channelId, seqNo);
			File f = new File("C:\\tmp\\" + downLoadInfo.getFileName());
			fou = new FileOutputStream(f);
			byte[] buff = new byte[8 * 1024];
			int n = downLoadInfo.read(buff);
			while (n != -1) {
				fou.write(buff, 0, n);
				fou.flush();
				n = downLoadInfo.read(buff);
			}
			System.out.println(Md5EncodeUtil.encode(f).equals(downLoadInfo.getFileMd5()));
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			if (downLoadInfo != null) {
				downLoadInfo.releaseResouces();
			}
			fou.close();
		}
	}

}
