package com.zbank.file.exception;

import com.zbank.file.constants.DealCode;

public class SDKException extends Exception {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private String code;

	public SDKException() {
		super("{code="+DealCode.SDK_ERROR.getCode()+",message="+DealCode.SDK_ERROR.getMsg()+"}");
		this.code = DealCode.SDK_ERROR.getCode();
	}
	public SDKException(String message) {
		super("{code="+DealCode.SDK_ERROR.getCode()+",message="+message+"}");
		this.code = DealCode.SDK_ERROR.getCode();
	}

	public SDKException(String message,Throwable cause) {
		super("{code="+DealCode.SDK_ERROR.getCode()+",message="+message+"}", cause);
		this.code = DealCode.SDK_ERROR.getCode();
	}
	

	public SDKException(String code,String message,Throwable cause) {
		super("{code="+code+",message="+message+"}", cause);
		this.code = code;
	}
	
	public SDKException(String code,String message) {
		super("{code="+code+",message="+message+"}");
		this.code = code;
	}

	
	public String getCode() {
		return code;
	}
}
